/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Secp256r1
extends CustomFpCurve {
    private static final long M = 0xFFFFFFFFL;
    private static final int ARR_LEN = 8;
    private static final int ARR_LEN2 = 16;
    private static final int[] P;
    private static final int[] PExt;
    private static final int P7 = -1;
    private static final int PExt15s1 = Integer.MAX_VALUE;

    static {
        int[] nArray = new int[8];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[6] = 1;
        nArray[7] = -1;
        P = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = 1;
        nArray2[3] = -2;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[6] = -2;
        nArray2[7] = 1;
        nArray2[8] = -2;
        nArray2[9] = 1;
        nArray2[10] = -2;
        nArray2[11] = 1;
        nArray2[12] = 1;
        nArray2[13] = -2;
        nArray2[14] = 2;
        nArray2[15] = -2;
        PExt = nArray2;
    }

    public Secp256r1() {
        super(P, "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF", 8, false);
        super.init(new Element(), new CustomFpCurve.Point(null, null, null), "1.2.840.10045.3.1.7", "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", "5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B", "FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551", "01", "04 6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296 4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        long xx08 = (long)xx[8] & 0xFFFFFFFFL;
        long xx09 = (long)xx[9] & 0xFFFFFFFFL;
        long xx10 = (long)xx[10] & 0xFFFFFFFFL;
        long xx11 = (long)xx[11] & 0xFFFFFFFFL;
        long xx12 = (long)xx[12] & 0xFFFFFFFFL;
        long xx13 = (long)xx[13] & 0xFFFFFFFFL;
        long xx14 = (long)xx[14] & 0xFFFFFFFFL;
        long xx15 = (long)xx[15] & 0xFFFFFFFFL;
        long n = 6L;
        long t0 = (xx08 -= 6L) + xx09;
        long t1 = xx09 + xx10;
        long t2 = xx10 + xx11 - xx15;
        long t3 = xx11 + xx12;
        long t4 = xx12 + xx13;
        long t5 = xx13 + xx14;
        long t6 = xx14 + xx15;
        long t7 = t5 - t0;
        long cc = 0L;
        z[0] = (int)(cc += ((long)xx[0] & 0xFFFFFFFFL) - t3 - t7);
        cc >>= 32;
        z[1] = (int)(cc += ((long)xx[1] & 0xFFFFFFFFL) + t1 - t4 - t6);
        cc >>= 32;
        z[2] = (int)(cc += ((long)xx[2] & 0xFFFFFFFFL) + t2 - t5);
        cc >>= 32;
        z[3] = (int)(cc += ((long)xx[3] & 0xFFFFFFFFL) + (t3 << 1) + t7 - t6);
        cc >>= 32;
        z[4] = (int)(cc += ((long)xx[4] & 0xFFFFFFFFL) + (t4 << 1) + xx14 - t1);
        cc >>= 32;
        z[5] = (int)(cc += ((long)xx[5] & 0xFFFFFFFFL) + (t5 << 1) - t2);
        cc >>= 32;
        z[6] = (int)(cc += ((long)xx[6] & 0xFFFFFFFFL) + (t6 << 1) + t7);
        cc >>= 32;
        z[7] = (int)(cc += ((long)xx[7] & 0xFFFFFFFFL) + (xx15 << 1) + xx08 - t2 - t4);
        cc >>= 32;
        this.elReduceInt((int)(cc += 6L), z);
    }

    @Override
    protected void elReduceInt(int x, int[] z) {
        long cc = 0L;
        if (x != 0) {
            long xx08 = (long)x & 0xFFFFFFFFL;
            z[0] = (int)(cc += ((long)z[0] & 0xFFFFFFFFL) + xx08);
            if ((cc >>= 32) != 0L) {
                z[1] = (int)(cc += (long)z[1] & 0xFFFFFFFFL);
                cc >>= 32;
                z[2] = (int)(cc += (long)z[2] & 0xFFFFFFFFL);
                cc >>= 32;
            }
            z[3] = (int)(cc += ((long)z[3] & 0xFFFFFFFFL) - xx08);
            if ((cc >>= 32) != 0L) {
                z[4] = (int)(cc += (long)z[4] & 0xFFFFFFFFL);
                cc >>= 32;
                z[5] = (int)(cc += (long)z[5] & 0xFFFFFFFFL);
                cc >>= 32;
            }
            z[6] = (int)(cc += ((long)z[6] & 0xFFFFFFFFL) - xx08);
            cc >>= 32;
            z[7] = (int)(cc += ((long)z[7] & 0xFFFFFFFFL) + xx08);
            cc >>= 32;
        }
        if (cc != 0L || z[7] == -1 && Nat.gte(8, z, P)) {
            this.addPInvTo(z);
        }
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        int C = Nat.add(8, x, y, z);
        if (C != 0 || z[7] == -1 && Nat.gte(8, z, P)) {
            this.addPInvTo(z);
        }
    }

    @Override
    protected void elAddOne(int[] x, int[] z) {
        int c = Nat.inc(8, x, z);
        if (c != 0 || z[7] == -1 && Nat.gte(8, z, P)) {
            this.addPInvTo(z);
        }
    }

    private void addPInvTo(int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) + 1L;
        z[0] = (int)c;
        if ((c >>= 32) != 0L) {
            z[1] = (int)(c += (long)z[1] & 0xFFFFFFFFL);
            c >>= 32;
            z[2] = (int)(c += (long)z[2] & 0xFFFFFFFFL);
            c >>= 32;
        }
        z[3] = (int)(c += ((long)z[3] & 0xFFFFFFFFL) - 1L);
        if ((c >>= 32) != 0L) {
            z[4] = (int)(c += (long)z[4] & 0xFFFFFFFFL);
            c >>= 32;
            z[5] = (int)(c += (long)z[5] & 0xFFFFFFFFL);
            c >>= 32;
        }
        z[6] = (int)(c += ((long)z[6] & 0xFFFFFFFFL) - 1L);
        c >>= 32;
        z[7] = (int)(c += ((long)z[7] & 0xFFFFFFFFL) + 1L);
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        if (Nat.sub(8, x, y, z) != 0) {
            long c = ((long)z[0] & 0xFFFFFFFFL) - 1L;
            z[0] = (int)c;
            if ((c >>= 32) != 0L) {
                z[1] = (int)(c += (long)z[1] & 0xFFFFFFFFL);
                c >>= 32;
                z[2] = (int)(c += (long)z[2] & 0xFFFFFFFFL);
                c >>= 32;
            }
            z[3] = (int)(c += ((long)z[3] & 0xFFFFFFFFL) + 1L);
            if ((c >>= 32) != 0L) {
                z[4] = (int)(c += (long)z[4] & 0xFFFFFFFFL);
                c >>= 32;
                z[5] = (int)(c += (long)z[5] & 0xFFFFFFFFL);
                c >>= 32;
            }
            z[6] = (int)(c += ((long)z[6] & 0xFFFFFFFFL) + 1L);
            c >>= 32;
            z[7] = (int)(c += ((long)z[7] & 0xFFFFFFFFL) - 1L);
        }
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        int c = Nat.shiftUpBit(8, x, 0, z);
        if (c != 0 || z[7] == -1 && Nat.gte(8, z, P)) {
            this.addPInvTo(z);
        }
    }

    @Override
    protected void elMultiply(int[] x, int[] y, int[] z) {
        int[] tt = new int[16];
        Nat.mul(8, x, y, tt);
        this.elReduce(tt, z);
    }

    @Override
    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
        int c = Nat.mulAddTo(8, x, y, zz);
        if (c != 0 || zz[15] >>> 1 >= Integer.MAX_VALUE && Nat.gte(16, zz, PExt)) {
            Nat.subFrom(16, PExt, zz);
        }
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Secp256r1.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(256, X);
            if (this.arr[7] == -1 && Nat.gte(8, this.arr, P)) {
                Nat.subFrom(8, P, this.arr);
            }
        }

        private Element(int[] x) {
            this.arr = x;
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            int[] x1 = this.arr;
            if (Nat.isZero(8, x1) || Nat.isOne(8, x1)) {
                return this;
            }
            int[] t1 = new int[8];
            int[] t2 = new int[8];
            Secp256r1.this.elSquare(x1, t1);
            Secp256r1.this.elMultiply(t1, x1, t1);
            Secp256r1.this.elSquareN(t1, 2, t2);
            Secp256r1.this.elMultiply(t2, t1, t2);
            Secp256r1.this.elSquareN(t2, 4, t1);
            Secp256r1.this.elMultiply(t1, t2, t1);
            Secp256r1.this.elSquareN(t1, 8, t2);
            Secp256r1.this.elMultiply(t2, t1, t2);
            Secp256r1.this.elSquareN(t2, 16, t1);
            Secp256r1.this.elMultiply(t1, t2, t1);
            Secp256r1.this.elSquareN(t1, 32, t1);
            Secp256r1.this.elMultiply(t1, x1, t1);
            Secp256r1.this.elSquareN(t1, 96, t1);
            Secp256r1.this.elMultiply(t1, x1, t1);
            Secp256r1.this.elSquareN(t1, 94, t1);
            Secp256r1.this.elSquare(t1, t2);
            return Arrays.equals(x1, t2) ? new Element(t1) : null;
        }
    }
}

