/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Secp521r1
extends CustomFpCurve {
    private static final int ARR_LEN = 17;
    private static final int[] P = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 511};
    private static final int P16 = 511;
    private static final long M = 0xFFFFFFFFL;

    public Secp521r1() {
        super(P, "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 17, false);
        super.init(new Element(), new Point(null, null, null), "1.3.132.0.35", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC", "0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409", "01", "04 00C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66 011839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E662C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        int xx32 = xx[32];
        int c = Nat.shiftDownBits(16, xx, 16, 9, xx32, z, 0) >>> 23;
        c += xx32 >>> 9;
        if ((c += Nat.addTo(16, xx, z)) > 511 || c == 511 && Arrays.equals(z, P)) {
            c += Nat.inc(16, z);
            c &= 0x1FF;
        }
        z[16] = c;
    }

    @Override
    protected void elReduceInt(int dummy, int[] z) {
        int z16 = z[16];
        int c = Nat.addWordTo(16, z16 >>> 9, z) + (z16 & 0x1FF);
        if (c > 511 || c == 511 && Arrays.equals(z, P)) {
            c += Nat.inc(16, z);
            c &= 0x1FF;
        }
        z[16] = c;
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        int c = Nat.add(16, x, y, z) + x[16] + y[16];
        if (c > 511 || c == 511 && Arrays.equals(z, P)) {
            c += Nat.inc(16, z);
            c &= 0x1FF;
        }
        z[16] = c;
    }

    @Override
    protected void elAddOne(int[] x, int[] z) {
        int c = Nat.inc(16, x, z) + x[16];
        if (c > 511 || c == 511 && Arrays.equals(z, P)) {
            c += Nat.inc(16, z);
            c &= 0x1FF;
        }
        z[16] = c;
    }

    @Override
    protected void elSquare(int[] x, int[] z) {
        int[] tt = new int[33];
        this.implSquare(x, tt);
        this.elReduce(tt, z);
    }

    @Override
    protected void elSquareN(int[] x, int n, int[] z) {
        int[] tt = new int[33];
        this.implSquare(x, tt);
        this.elReduce(tt, z);
        while (--n > 0) {
            this.implSquare(z, tt);
            this.elReduce(tt, z);
        }
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        int c = Nat.sub(16, x, y, z) + x[16] - y[16];
        if (c < 0) {
            c += Nat.dec(16, z);
            c &= 0x1FF;
        }
        z[16] = c;
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        int x16 = x[16];
        int c = Nat.shiftUpBit(16, x, x16 << 23, z) | x16 << 1;
        z[16] = c & 0x1FF;
    }

    private int addTo(int len, int[] x, int xOff, int[] z, int zOff, int cIn) {
        long c = (long)cIn & 0xFFFFFFFFL;
        int i = 0;
        while (i < len) {
            z[zOff + i] = (int)(c += ((long)x[xOff + i] & 0xFFFFFFFFL) + ((long)z[zOff + i] & 0xFFFFFFFFL));
            c >>>= 32;
            ++i;
        }
        return (int)c;
    }

    private boolean gte(int len, int[] x, int xOff, int[] y, int yOff) {
        int i = len - 1;
        while (i >= 0) {
            int x_i = x[xOff + i] ^ Integer.MIN_VALUE;
            int y_i = y[yOff + i] ^ Integer.MIN_VALUE;
            if (x_i < y_i) {
                return false;
            }
            if (x_i > y_i) {
                return true;
            }
            --i;
        }
        return true;
    }

    private void implSquare(int[] x, int[] zz) {
        int LEN = 8;
        Nat.square(8, x, zz);
        Nat.square(8, x, 8, zz, 16);
        int c24 = Nat.addTo(8, zz, 8, zz, 16);
        System.arraycopy(zz, 16, zz, 8, 8);
        int c16 = c24 + Nat.addTo(8, zz, 0, zz, 8);
        c24 += this.addTo(8, zz, 24, zz, 16, c16);
        int[] dx = new int[8];
        if (this.gte(8, x, 0, x, 8)) {
            Nat.sub(8, x, 0, x, 8, dx, 0);
        } else {
            Nat.sub(8, x, 8, x, 0, dx, 0);
        }
        int[] tt = new int[16];
        Nat.square(8, dx, tt);
        Nat.addWordAt(32, c24 += Nat.subFrom(16, tt, 0, zz, 8), zz, 24);
        int x16 = x[16];
        zz[32] = Nat.mulWordAddTo(16, x16 << 1, x, 0, zz, 16) + x16 * x16;
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Secp521r1.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(521, X);
            if (Arrays.equals(this.arr, P)) {
                Nat.zero(17, this.arr);
            }
        }

        private Element(int[] x) {
            this.arr = x;
        }

        @Override
        protected ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            int[] x1 = this.arr;
            if (Nat.isZero(17, x1) || Nat.isOne(17, x1)) {
                return this;
            }
            int[] t1 = new int[17];
            int[] t2 = new int[17];
            Secp521r1.this.elSquareN(x1, 519, t1);
            Secp521r1.this.elSquare(t1, t2);
            return Arrays.equals(x1, t2) ? new Element(t1) : null;
        }
    }

    private class Point
    extends CustomFpCurve.Point {
        private Point(ECCurve.ECElement x, ECCurve.ECElement y) {
            super(x, y);
        }

        private Point(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            super(x, y, zs);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y) {
            return new Point(x, y);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            return new Point(x, y, zs);
        }

        @Override
        public ECCurve.ECPoint add(ECCurve.ECPoint b) {
            int[] S1;
            int[] U1;
            int[] S2;
            int[] U2;
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this;
            }
            if (this == b) {
                return this.twice();
            }
            Element X1 = (Element)this.x;
            Element Y1 = (Element)this.y;
            Element X2 = (Element)b.getXCoord();
            Element Y2 = (Element)b.getYCoord();
            Element Z1 = (Element)this.zs[0];
            Element Z2 = (Element)b.getZCoord(0);
            int[] t1 = new int[17];
            int[] t2 = new int[17];
            int[] t3 = new int[17];
            int[] t4 = new int[17];
            boolean Z1IsOne = Z1.isOne();
            if (Z1IsOne) {
                U2 = X2.arr;
                S2 = Y2.arr;
            } else {
                S2 = t3;
                Secp521r1.this.elSquare(Z1.arr, S2);
                U2 = t2;
                Secp521r1.this.elMultiply(S2, X2.arr, U2);
                Secp521r1.this.elMultiply(S2, Z1.arr, S2);
                Secp521r1.this.elMultiply(S2, Y2.arr, S2);
            }
            boolean Z2IsOne = Z2.isOne();
            if (Z2IsOne) {
                U1 = X1.arr;
                S1 = Y1.arr;
            } else {
                S1 = t4;
                Secp521r1.this.elSquare(Z2.arr, S1);
                U1 = t1;
                Secp521r1.this.elMultiply(S1, X1.arr, U1);
                Secp521r1.this.elMultiply(S1, Z2.arr, S1);
                Secp521r1.this.elMultiply(S1, Y1.arr, S1);
            }
            int[] H = new int[17];
            Secp521r1.this.elSubtract(U1, U2, H);
            int[] R = t2;
            Secp521r1.this.elSubtract(S1, S2, R);
            if (Nat.isZero(17, H)) {
                if (Nat.isZero(17, R)) {
                    return this.twice();
                }
                return Secp521r1.this.getInfinity();
            }
            int[] HSquared = t3;
            Secp521r1.this.elSquare(H, HSquared);
            int[] G = new int[17];
            Secp521r1.this.elMultiply(HSquared, H, G);
            int[] V = t3;
            Secp521r1.this.elMultiply(HSquared, U1, V);
            Secp521r1.this.elMultiply(S1, G, t1);
            Element X3 = new Element(t4);
            Secp521r1.this.elSquare(R, X3.arr);
            Secp521r1.this.elAdd(X3.arr, G, X3.arr);
            Secp521r1.this.elSubtract(X3.arr, V, X3.arr);
            Secp521r1.this.elSubtract(X3.arr, V, X3.arr);
            Element Y3 = new Element(G);
            Secp521r1.this.elSubtract(V, X3.arr, Y3.arr);
            Secp521r1.this.elMultiply(Y3.arr, R, t2);
            Secp521r1.this.elSubtract(t2, t1, Y3.arr);
            Element Z3 = new Element(H);
            if (!Z1IsOne) {
                Secp521r1.this.elMultiply(Z3.arr, Z1.arr, Z3.arr);
            }
            if (!Z2IsOne) {
                Secp521r1.this.elMultiply(Z3.arr, Z2.arr, Z3.arr);
            }
            return new Point((ECCurve.ECElement)X3, (ECCurve.ECElement)Y3, new ECCurve.ECElement[]{Z3});
        }

        @Override
        public ECCurve.ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            Element Y1 = (Element)this.y;
            if (Y1.isZero()) {
                return Secp521r1.this.getInfinity();
            }
            Element X1 = (Element)this.x;
            Element Z1 = (Element)this.zs[0];
            int[] t1 = new int[17];
            int[] t2 = new int[17];
            int[] Y1Squared = new int[17];
            Secp521r1.this.elSquare(Y1.arr, Y1Squared);
            int[] T = new int[17];
            Secp521r1.this.elSquare(Y1Squared, T);
            boolean Z1IsOne = Z1.isOne();
            int[] Z1Squared = Z1.arr;
            if (!Z1IsOne) {
                Z1Squared = t2;
                Secp521r1.this.elSquare(Z1.arr, Z1Squared);
            }
            Secp521r1.this.elSubtract(X1.arr, Z1Squared, t1);
            int[] M = t2;
            Secp521r1.this.elAdd(X1.arr, Z1Squared, M);
            Secp521r1.this.elMultiply(M, t1, M);
            Nat.addBothTo(17, M, M, M);
            Secp521r1.this.elReduceInt(0, M);
            int[] S = Y1Squared;
            Secp521r1.this.elMultiply(Y1Squared, X1.arr, S);
            Nat.shiftUpBits(17, S, 2, 0);
            Secp521r1.this.elReduceInt(0, S);
            Nat.shiftUpBits(17, T, 3, 0, t1);
            Secp521r1.this.elReduceInt(0, t1);
            Element X3 = new Element(T);
            Secp521r1.this.elSquare(M, X3.arr);
            Secp521r1.this.elSubtract(X3.arr, S, X3.arr);
            Secp521r1.this.elSubtract(X3.arr, S, X3.arr);
            Element Y3 = new Element(S);
            Secp521r1.this.elSubtract(S, X3.arr, Y3.arr);
            Secp521r1.this.elMultiply(Y3.arr, M, Y3.arr);
            Secp521r1.this.elSubtract(Y3.arr, t1, Y3.arr);
            Element Z3 = new Element(M);
            Secp521r1.this.elTwice(Y1.arr, Z3.arr);
            if (!Z1IsOne) {
                Secp521r1.this.elMultiply(Z3.arr, Z1.arr, Z3.arr);
            }
            return new Point((ECCurve.ECElement)X3, (ECCurve.ECElement)Y3, new ECCurve.ECElement[]{Z3});
        }
    }
}

