/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.hash;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.hash.IHash;

public class HMAC {
    private final int BLOCK_SIZE = 64;
    private final Binary IPAD = new Binary(64, 54);
    private final Binary OPAD = new Binary(64, 92);
    private Binary keyIPad = null;
    private Binary keyOPad = null;
    private IHash hash;

    public HMAC(IHash hash) {
        Ex.MUST(hash != null, "\u0410\u043b\u0433\u043e\u0440\u0438\u0442\u043c \u0445\u0435\u0448\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f = null");
        this.hash = hash;
    }

    public HMAC(IHash hash, Binary key) {
        Ex.MUST(hash != null, "\u0410\u043b\u0433\u043e\u0440\u0438\u0442\u043c \u0445\u0435\u0448\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f = null");
        this.hash = hash;
        this.setKey(key);
    }

    public HMAC setKey(Binary key) {
        if (key.size() > 64) {
            key = this.hash.calc(key);
        }
        Binary keyPadded = key.clone();
        keyPadded.resize(64);
        this.keyIPad = Binary.xor(keyPadded, this.IPAD);
        this.keyOPad = Binary.xor(keyPadded, this.OPAD);
        return this;
    }

    public int getSize() {
        return this.hash.size();
    }

    public Binary calc(Binary data) {
        Ex.MUST(this.keyIPad != null, "HMAC key not set");
        Binary hash_ipad = this.hash.calc(Binary.Bin(this.keyIPad, data));
        Binary result = this.hash.calc(Binary.Bin(this.keyOPad, hash_ipad));
        return result;
    }

    public HMAC clone() {
        return new HMAC(this.hash.clone());
    }

    public HMAC cloneWithKey() {
        HMAC clone = new HMAC(this.hash.clone());
        if (this.keyIPad != null) {
            clone.keyIPad = this.keyIPad.clone();
            clone.keyOPad = this.keyOPad.clone();
        }
        return clone;
    }
}

