/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.hash;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.crypt.hash.IHash;

public class MD5
extends IHash {
    public static final int HASH_SIZE = 16;
    private static final int BLOCK_SIZE = 64;
    private int[] H = new int[4];
    private int[] W = new int[16];

    public MD5() {
        super(64);
        this.reset();
    }

    @Override
    public String name() {
        return "MD5";
    }

    @Override
    public int size() {
        return 16;
    }

    @Override
    public MD5 clone() {
        return new MD5();
    }

    @Override
    public MD5 cloneState() {
        MD5 cloned = (MD5)this.cloneStateBase();
        cloned.H = Arrays.copyOf(this.H, this.H.length);
        return cloned;
    }

    @Override
    public void reset() {
        super.reset();
        this.H[0] = 1732584193;
        this.H[1] = -271733879;
        this.H[2] = -1732584194;
        this.H[3] = 271733878;
    }

    @Override
    public Binary getHash() {
        this.finish();
        Binary hash = new Binary(16);
        int i = 0;
        while (i < this.H.length) {
            hash.setIntLE(i << 2, this.H[i]);
            ++i;
        }
        this.reset();
        return hash;
    }

    private void finish() {
        this.tail.add(128);
        if (this.tail.size() > 56) {
            this.tail.resize(64);
            this.processBlock(this.tail, 0);
            this.tail.clear();
        }
        this.tail.resize(64);
        this.tail.setLongLE(this.tail.size() - 8, this.processedBytes << 3);
        this.processBlock(this.tail, 0);
    }

    @Override
    protected void processBlock(Binary data, int offset) {
        byte[] buf = data.getDataRef();
        int i = 0;
        while (i < 16) {
            this.W[i] = buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | buf[offset + 3] << 24;
            ++i;
            offset += 4;
        }
        int a = this.H[0];
        int b = this.H[1];
        int c = this.H[2];
        int d = this.H[3];
        a = Integer.rotateLeft(a + (b & c | ~b & d) + this.W[0] + -680876936, 7) + b;
        d = Integer.rotateLeft(d + (a & b | ~a & c) + this.W[1] + -389564586, 12) + a;
        c = Integer.rotateLeft(c + (d & a | ~d & b) + this.W[2] + 606105819, 17) + d;
        b = Integer.rotateLeft(b + (c & d | ~c & a) + this.W[3] + -1044525330, 22) + c;
        a = Integer.rotateLeft(a + (b & c | ~b & d) + this.W[4] + -176418897, 7) + b;
        d = Integer.rotateLeft(d + (a & b | ~a & c) + this.W[5] + 1200080426, 12) + a;
        c = Integer.rotateLeft(c + (d & a | ~d & b) + this.W[6] + -1473231341, 17) + d;
        b = Integer.rotateLeft(b + (c & d | ~c & a) + this.W[7] + -45705983, 22) + c;
        a = Integer.rotateLeft(a + (b & c | ~b & d) + this.W[8] + 1770035416, 7) + b;
        d = Integer.rotateLeft(d + (a & b | ~a & c) + this.W[9] + -1958414417, 12) + a;
        c = Integer.rotateLeft(c + (d & a | ~d & b) + this.W[10] + -42063, 17) + d;
        b = Integer.rotateLeft(b + (c & d | ~c & a) + this.W[11] + -1990404162, 22) + c;
        a = Integer.rotateLeft(a + (b & c | ~b & d) + this.W[12] + 1804603682, 7) + b;
        d = Integer.rotateLeft(d + (a & b | ~a & c) + this.W[13] + -40341101, 12) + a;
        c = Integer.rotateLeft(c + (d & a | ~d & b) + this.W[14] + -1502002290, 17) + d;
        b = Integer.rotateLeft(b + (c & d | ~c & a) + this.W[15] + 1236535329, 22) + c;
        a = Integer.rotateLeft(a + (b & d | c & ~d) + this.W[1] + -165796510, 5) + b;
        d = Integer.rotateLeft(d + (a & c | b & ~c) + this.W[6] + -1069501632, 9) + a;
        c = Integer.rotateLeft(c + (d & b | a & ~b) + this.W[11] + 643717713, 14) + d;
        b = Integer.rotateLeft(b + (c & a | d & ~a) + this.W[0] + -373897302, 20) + c;
        a = Integer.rotateLeft(a + (b & d | c & ~d) + this.W[5] + -701558691, 5) + b;
        d = Integer.rotateLeft(d + (a & c | b & ~c) + this.W[10] + 38016083, 9) + a;
        c = Integer.rotateLeft(c + (d & b | a & ~b) + this.W[15] + -660478335, 14) + d;
        b = Integer.rotateLeft(b + (c & a | d & ~a) + this.W[4] + -405537848, 20) + c;
        a = Integer.rotateLeft(a + (b & d | c & ~d) + this.W[9] + 568446438, 5) + b;
        d = Integer.rotateLeft(d + (a & c | b & ~c) + this.W[14] + -1019803690, 9) + a;
        c = Integer.rotateLeft(c + (d & b | a & ~b) + this.W[3] + -187363961, 14) + d;
        b = Integer.rotateLeft(b + (c & a | d & ~a) + this.W[8] + 1163531501, 20) + c;
        a = Integer.rotateLeft(a + (b & d | c & ~d) + this.W[13] + -1444681467, 5) + b;
        d = Integer.rotateLeft(d + (a & c | b & ~c) + this.W[2] + -51403784, 9) + a;
        c = Integer.rotateLeft(c + (d & b | a & ~b) + this.W[7] + 1735328473, 14) + d;
        b = Integer.rotateLeft(b + (c & a | d & ~a) + this.W[12] + -1926607734, 20) + c;
        a = Integer.rotateLeft(a + (b ^ c ^ d) + this.W[5] + -378558, 4) + b;
        d = Integer.rotateLeft(d + (a ^ b ^ c) + this.W[8] + -2022574463, 11) + a;
        c = Integer.rotateLeft(c + (d ^ a ^ b) + this.W[11] + 1839030562, 16) + d;
        b = Integer.rotateLeft(b + (c ^ d ^ a) + this.W[14] + -35309556, 23) + c;
        a = Integer.rotateLeft(a + (b ^ c ^ d) + this.W[1] + -1530992060, 4) + b;
        d = Integer.rotateLeft(d + (a ^ b ^ c) + this.W[4] + 1272893353, 11) + a;
        c = Integer.rotateLeft(c + (d ^ a ^ b) + this.W[7] + -155497632, 16) + d;
        b = Integer.rotateLeft(b + (c ^ d ^ a) + this.W[10] + -1094730640, 23) + c;
        a = Integer.rotateLeft(a + (b ^ c ^ d) + this.W[13] + 681279174, 4) + b;
        d = Integer.rotateLeft(d + (a ^ b ^ c) + this.W[0] + -358537222, 11) + a;
        c = Integer.rotateLeft(c + (d ^ a ^ b) + this.W[3] + -722521979, 16) + d;
        b = Integer.rotateLeft(b + (c ^ d ^ a) + this.W[6] + 76029189, 23) + c;
        a = Integer.rotateLeft(a + (b ^ c ^ d) + this.W[9] + -640364487, 4) + b;
        d = Integer.rotateLeft(d + (a ^ b ^ c) + this.W[12] + -421815835, 11) + a;
        c = Integer.rotateLeft(c + (d ^ a ^ b) + this.W[15] + 530742520, 16) + d;
        b = Integer.rotateLeft(b + (c ^ d ^ a) + this.W[2] + -995338651, 23) + c;
        a = Integer.rotateLeft(a + (c ^ (b | ~d)) + this.W[0] + -198630844, 6) + b;
        d = Integer.rotateLeft(d + (b ^ (a | ~c)) + this.W[7] + 1126891415, 10) + a;
        c = Integer.rotateLeft(c + (a ^ (d | ~b)) + this.W[14] + -1416354905, 15) + d;
        b = Integer.rotateLeft(b + (d ^ (c | ~a)) + this.W[5] + -57434055, 21) + c;
        a = Integer.rotateLeft(a + (c ^ (b | ~d)) + this.W[12] + 1700485571, 6) + b;
        d = Integer.rotateLeft(d + (b ^ (a | ~c)) + this.W[3] + -1894986606, 10) + a;
        c = Integer.rotateLeft(c + (a ^ (d | ~b)) + this.W[10] + -1051523, 15) + d;
        b = Integer.rotateLeft(b + (d ^ (c | ~a)) + this.W[1] + -2054922799, 21) + c;
        a = Integer.rotateLeft(a + (c ^ (b | ~d)) + this.W[8] + 1873313359, 6) + b;
        d = Integer.rotateLeft(d + (b ^ (a | ~c)) + this.W[15] + -30611744, 10) + a;
        c = Integer.rotateLeft(c + (a ^ (d | ~b)) + this.W[6] + -1560198380, 15) + d;
        b = Integer.rotateLeft(b + (d ^ (c | ~a)) + this.W[13] + 1309151649, 21) + c;
        a = Integer.rotateLeft(a + (c ^ (b | ~d)) + this.W[4] + -145523070, 6) + b;
        d = Integer.rotateLeft(d + (b ^ (a | ~c)) + this.W[11] + -1120210379, 10) + a;
        c = Integer.rotateLeft(c + (a ^ (d | ~b)) + this.W[2] + 718787259, 15) + d;
        b = Integer.rotateLeft(b + (d ^ (c | ~a)) + this.W[9] + -343485551, 21) + c;
        this.H[0] = this.H[0] + a;
        this.H[1] = this.H[1] + b;
        this.H[2] = this.H[2] + c;
        this.H[3] = this.H[3] + d;
    }
}

