/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.hash;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.crypt.hash.IHash;

public class RIPEMD160
extends IHash {
    public static final int HASH_SIZE = 20;
    private static final int BLOCK_SIZE = 64;
    private int[] X = new int[16];
    private int[] H = new int[5];

    public RIPEMD160() {
        super(64);
        this.reset();
    }

    @Override
    public String name() {
        return "RIPEMD-160";
    }

    @Override
    public int size() {
        return 20;
    }

    @Override
    public RIPEMD160 clone() {
        return new RIPEMD160();
    }

    @Override
    public RIPEMD160 cloneState() {
        RIPEMD160 cloned = (RIPEMD160)this.cloneStateBase();
        cloned.H = Arrays.copyOf(this.H, this.H.length);
        return cloned;
    }

    @Override
    public void reset() {
        super.reset();
        this.H[0] = 1732584193;
        this.H[1] = -271733879;
        this.H[2] = -1732584194;
        this.H[3] = 271733878;
        this.H[4] = -1009589776;
    }

    @Override
    public Binary getHash() {
        this.finish();
        Binary hash = new Binary(20);
        int i = 0;
        while (i < this.H.length) {
            hash.setIntLE(i << 2, this.H[i]);
            ++i;
        }
        this.reset();
        return hash;
    }

    private void finish() {
        this.tail.add(128);
        if (this.tail.size() > 56) {
            this.tail.resize(64);
            this.processBlock(this.tail, 0);
            this.tail.clear();
        }
        this.tail.resize(64);
        this.tail.setLongLE(this.tail.size() - 8, this.processedBytes << 3);
        this.processBlock(this.tail, 0);
    }

    @Override
    protected void processBlock(Binary data, int offset) {
        byte[] buf = data.getDataRef();
        int j = 0;
        while (j < 16) {
            this.X[j] = buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | buf[offset + 3] << 24;
            ++j;
            offset += 4;
        }
        int al = this.H[0];
        int bl = this.H[1];
        int cl = this.H[2];
        int dl = this.H[3];
        int el = this.H[4];
        int ar = this.H[0];
        int br = this.H[1];
        int cr = this.H[2];
        int dr = this.H[3];
        int er = this.H[4];
        al = Integer.rotateLeft(al + (bl ^ cl ^ dl) + this.X[0], 11) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al ^ bl ^ cl) + this.X[1], 14) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el ^ al ^ bl) + this.X[2], 15) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl ^ el ^ al) + this.X[3], 12) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl ^ dl ^ el) + this.X[4], 5) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl ^ cl ^ dl) + this.X[5], 8) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al ^ bl ^ cl) + this.X[6], 7) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el ^ al ^ bl) + this.X[7], 9) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl ^ el ^ al) + this.X[8], 11) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl ^ dl ^ el) + this.X[9], 13) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl ^ cl ^ dl) + this.X[10], 14) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al ^ bl ^ cl) + this.X[11], 15) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el ^ al ^ bl) + this.X[12], 6) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl ^ el ^ al) + this.X[13], 7) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl ^ dl ^ el) + this.X[14], 9) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl ^ cl ^ dl) + this.X[15], 8) + el;
        cl = Integer.rotateLeft(cl, 10);
        ar = Integer.rotateLeft(ar + (br ^ (cr | ~dr)) + this.X[5] + 1352829926, 8) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar ^ (br | ~cr)) + this.X[14] + 1352829926, 9) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er ^ (ar | ~br)) + this.X[7] + 1352829926, 9) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr ^ (er | ~ar)) + this.X[0] + 1352829926, 11) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr ^ (dr | ~er)) + this.X[9] + 1352829926, 13) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br ^ (cr | ~dr)) + this.X[2] + 1352829926, 15) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar ^ (br | ~cr)) + this.X[11] + 1352829926, 15) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er ^ (ar | ~br)) + this.X[4] + 1352829926, 5) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr ^ (er | ~ar)) + this.X[13] + 1352829926, 7) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr ^ (dr | ~er)) + this.X[6] + 1352829926, 7) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br ^ (cr | ~dr)) + this.X[15] + 1352829926, 8) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar ^ (br | ~cr)) + this.X[8] + 1352829926, 11) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er ^ (ar | ~br)) + this.X[1] + 1352829926, 14) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr ^ (er | ~ar)) + this.X[10] + 1352829926, 14) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr ^ (dr | ~er)) + this.X[3] + 1352829926, 12) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br ^ (cr | ~dr)) + this.X[12] + 1352829926, 6) + er;
        cr = Integer.rotateLeft(cr, 10);
        el = Integer.rotateLeft(el + (al & bl | ~al & cl) + this.X[7] + 1518500249, 7) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el & al | ~el & bl) + this.X[4] + 1518500249, 6) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl & el | ~dl & al) + this.X[13] + 1518500249, 8) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl & dl | ~cl & el) + this.X[1] + 1518500249, 13) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl & cl | ~bl & dl) + this.X[10] + 1518500249, 11) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al & bl | ~al & cl) + this.X[6] + 1518500249, 9) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el & al | ~el & bl) + this.X[15] + 1518500249, 7) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl & el | ~dl & al) + this.X[3] + 1518500249, 15) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl & dl | ~cl & el) + this.X[12] + 1518500249, 7) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl & cl | ~bl & dl) + this.X[0] + 1518500249, 12) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al & bl | ~al & cl) + this.X[9] + 1518500249, 15) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el & al | ~el & bl) + this.X[5] + 1518500249, 9) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl & el | ~dl & al) + this.X[2] + 1518500249, 11) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl & dl | ~cl & el) + this.X[14] + 1518500249, 7) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl & cl | ~bl & dl) + this.X[11] + 1518500249, 13) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al & bl | ~al & cl) + this.X[8] + 1518500249, 12) + dl;
        bl = Integer.rotateLeft(bl, 10);
        er = Integer.rotateLeft(er + (ar & cr | br & ~cr) + this.X[6] + 1548603684, 9) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er & br | ar & ~br) + this.X[11] + 1548603684, 13) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr & ar | er & ~ar) + this.X[3] + 1548603684, 15) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr & er | dr & ~er) + this.X[7] + 1548603684, 7) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br & dr | cr & ~dr) + this.X[0] + 1548603684, 12) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar & cr | br & ~cr) + this.X[13] + 1548603684, 8) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er & br | ar & ~br) + this.X[5] + 1548603684, 9) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr & ar | er & ~ar) + this.X[10] + 1548603684, 11) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr & er | dr & ~er) + this.X[14] + 1548603684, 7) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br & dr | cr & ~dr) + this.X[15] + 1548603684, 7) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar & cr | br & ~cr) + this.X[8] + 1548603684, 12) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er & br | ar & ~br) + this.X[12] + 1548603684, 7) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr & ar | er & ~ar) + this.X[4] + 1548603684, 6) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr & er | dr & ~er) + this.X[9] + 1548603684, 15) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br & dr | cr & ~dr) + this.X[1] + 1548603684, 13) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar & cr | br & ~cr) + this.X[2] + 1548603684, 11) + dr;
        br = Integer.rotateLeft(br, 10);
        dl = Integer.rotateLeft(dl + ((el | ~al) ^ bl) + this.X[3] + 1859775393, 11) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + ((dl | ~el) ^ al) + this.X[10] + 1859775393, 13) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + ((cl | ~dl) ^ el) + this.X[14] + 1859775393, 6) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + ((bl | ~cl) ^ dl) + this.X[4] + 1859775393, 7) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + ((al | ~bl) ^ cl) + this.X[9] + 1859775393, 14) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + ((el | ~al) ^ bl) + this.X[15] + 1859775393, 9) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + ((dl | ~el) ^ al) + this.X[8] + 1859775393, 13) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + ((cl | ~dl) ^ el) + this.X[1] + 1859775393, 15) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + ((bl | ~cl) ^ dl) + this.X[2] + 1859775393, 14) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + ((al | ~bl) ^ cl) + this.X[7] + 1859775393, 8) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + ((el | ~al) ^ bl) + this.X[0] + 1859775393, 13) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + ((dl | ~el) ^ al) + this.X[6] + 1859775393, 6) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + ((cl | ~dl) ^ el) + this.X[13] + 1859775393, 5) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + ((bl | ~cl) ^ dl) + this.X[11] + 1859775393, 12) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + ((al | ~bl) ^ cl) + this.X[5] + 1859775393, 7) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + ((el | ~al) ^ bl) + this.X[12] + 1859775393, 5) + cl;
        al = Integer.rotateLeft(al, 10);
        dr = Integer.rotateLeft(dr + ((er | ~ar) ^ br) + this.X[15] + 1836072691, 9) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + ((dr | ~er) ^ ar) + this.X[5] + 1836072691, 7) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + ((cr | ~dr) ^ er) + this.X[1] + 1836072691, 15) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + ((br | ~cr) ^ dr) + this.X[3] + 1836072691, 11) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + ((ar | ~br) ^ cr) + this.X[7] + 1836072691, 8) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + ((er | ~ar) ^ br) + this.X[14] + 1836072691, 6) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + ((dr | ~er) ^ ar) + this.X[6] + 1836072691, 6) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + ((cr | ~dr) ^ er) + this.X[9] + 1836072691, 14) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + ((br | ~cr) ^ dr) + this.X[11] + 1836072691, 12) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + ((ar | ~br) ^ cr) + this.X[8] + 1836072691, 13) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + ((er | ~ar) ^ br) + this.X[12] + 1836072691, 5) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + ((dr | ~er) ^ ar) + this.X[2] + 1836072691, 14) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + ((cr | ~dr) ^ er) + this.X[10] + 1836072691, 13) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + ((br | ~cr) ^ dr) + this.X[0] + 1836072691, 13) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + ((ar | ~br) ^ cr) + this.X[4] + 1836072691, 7) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + ((er | ~ar) ^ br) + this.X[13] + 1836072691, 5) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cl = Integer.rotateLeft(cl + (dl & al | el & ~al) + this.X[1] + -1894007588, 11) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl & el | dl & ~el) + this.X[9] + -1894007588, 12) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl & dl | cl & ~dl) + this.X[11] + -1894007588, 14) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al & cl | bl & ~cl) + this.X[10] + -1894007588, 15) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el & bl | al & ~bl) + this.X[0] + -1894007588, 14) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl & al | el & ~al) + this.X[8] + -1894007588, 15) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl & el | dl & ~el) + this.X[12] + -1894007588, 9) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl & dl | cl & ~dl) + this.X[4] + -1894007588, 8) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al & cl | bl & ~cl) + this.X[13] + -1894007588, 9) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el & bl | al & ~bl) + this.X[3] + -1894007588, 14) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl & al | el & ~al) + this.X[7] + -1894007588, 5) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl & el | dl & ~el) + this.X[15] + -1894007588, 6) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl & dl | cl & ~dl) + this.X[14] + -1894007588, 8) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al & cl | bl & ~cl) + this.X[5] + -1894007588, 6) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el & bl | al & ~bl) + this.X[6] + -1894007588, 5) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl & al | el & ~al) + this.X[2] + -1894007588, 12) + bl;
        el = Integer.rotateLeft(el, 10);
        cr = Integer.rotateLeft(cr + (dr & er | ~dr & ar) + this.X[8] + 2053994217, 15) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr & dr | ~cr & er) + this.X[6] + 2053994217, 5) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br & cr | ~br & dr) + this.X[4] + 2053994217, 8) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar & br | ~ar & cr) + this.X[1] + 2053994217, 11) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er & ar | ~er & br) + this.X[3] + 2053994217, 14) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr & er | ~dr & ar) + this.X[11] + 2053994217, 14) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr & dr | ~cr & er) + this.X[15] + 2053994217, 6) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br & cr | ~br & dr) + this.X[0] + 2053994217, 14) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar & br | ~ar & cr) + this.X[5] + 2053994217, 6) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er & ar | ~er & br) + this.X[12] + 2053994217, 9) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr & er | ~dr & ar) + this.X[2] + 2053994217, 12) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr & dr | ~cr & er) + this.X[13] + 2053994217, 9) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br & cr | ~br & dr) + this.X[9] + 2053994217, 12) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar & br | ~ar & cr) + this.X[7] + 2053994217, 5) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er & ar | ~er & br) + this.X[10] + 2053994217, 15) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr & er | ~dr & ar) + this.X[14] + 2053994217, 8) + br;
        er = Integer.rotateLeft(er, 10);
        bl = Integer.rotateLeft(bl + (cl ^ (dl | ~el)) + this.X[4] + -1454113458, 9) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl ^ (cl | ~dl)) + this.X[0] + -1454113458, 15) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al ^ (bl | ~cl)) + this.X[5] + -1454113458, 5) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el ^ (al | ~bl)) + this.X[9] + -1454113458, 11) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl ^ (el | ~al)) + this.X[7] + -1454113458, 6) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl ^ (dl | ~el)) + this.X[12] + -1454113458, 8) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl ^ (cl | ~dl)) + this.X[2] + -1454113458, 13) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al ^ (bl | ~cl)) + this.X[10] + -1454113458, 12) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el ^ (al | ~bl)) + this.X[14] + -1454113458, 5) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl ^ (el | ~al)) + this.X[1] + -1454113458, 12) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl ^ (dl | ~el)) + this.X[3] + -1454113458, 13) + al;
        dl = Integer.rotateLeft(dl, 10);
        al = Integer.rotateLeft(al + (bl ^ (cl | ~dl)) + this.X[8] + -1454113458, 14) + el;
        cl = Integer.rotateLeft(cl, 10);
        el = Integer.rotateLeft(el + (al ^ (bl | ~cl)) + this.X[11] + -1454113458, 11) + dl;
        bl = Integer.rotateLeft(bl, 10);
        dl = Integer.rotateLeft(dl + (el ^ (al | ~bl)) + this.X[6] + -1454113458, 8) + cl;
        al = Integer.rotateLeft(al, 10);
        cl = Integer.rotateLeft(cl + (dl ^ (el | ~al)) + this.X[15] + -1454113458, 5) + bl;
        el = Integer.rotateLeft(el, 10);
        bl = Integer.rotateLeft(bl + (cl ^ (dl | ~el)) + this.X[13] + -1454113458, 6) + al;
        dl = Integer.rotateLeft(dl, 10);
        br = Integer.rotateLeft(br + (cr ^ dr ^ er) + this.X[12], 8) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br ^ cr ^ dr) + this.X[15], 5) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar ^ br ^ cr) + this.X[10], 12) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er ^ ar ^ br) + this.X[4], 9) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr ^ er ^ ar) + this.X[1], 12) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr ^ dr ^ er) + this.X[5], 5) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br ^ cr ^ dr) + this.X[8], 14) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar ^ br ^ cr) + this.X[7], 6) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er ^ ar ^ br) + this.X[6], 8) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr ^ er ^ ar) + this.X[2], 13) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr ^ dr ^ er) + this.X[13], 6) + ar;
        dr = Integer.rotateLeft(dr, 10);
        ar = Integer.rotateLeft(ar + (br ^ cr ^ dr) + this.X[14], 5) + er;
        cr = Integer.rotateLeft(cr, 10);
        er = Integer.rotateLeft(er + (ar ^ br ^ cr) + this.X[0], 15) + dr;
        br = Integer.rotateLeft(br, 10);
        dr = Integer.rotateLeft(dr + (er ^ ar ^ br) + this.X[3], 13) + cr;
        ar = Integer.rotateLeft(ar, 10);
        cr = Integer.rotateLeft(cr + (dr ^ er ^ ar) + this.X[9], 11) + br;
        er = Integer.rotateLeft(er, 10);
        br = Integer.rotateLeft(br + (cr ^ dr ^ er) + this.X[11], 11) + ar;
        dr = Integer.rotateLeft(dr, 10);
        this.H[1] = this.H[2] + dl + er;
        this.H[2] = this.H[3] + el + ar;
        this.H[3] = this.H[4] + al + br;
        this.H[4] = this.H[0] + bl + cr;
        this.H[0] = dr += cl + this.H[1];
    }
}

