/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.hash;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.crypt.hash.IHash;

public class SHA1
extends IHash {
    public static final int HASH_SIZE = 20;
    private static final int BLOCK_SIZE = 64;
    private int[] H = new int[5];
    private int[] W = new int[80];

    public SHA1() {
        super(64);
        this.reset();
    }

    @Override
    public String name() {
        return "SHA-1";
    }

    @Override
    public int size() {
        return 20;
    }

    @Override
    public SHA1 clone() {
        return new SHA1();
    }

    @Override
    public SHA1 cloneState() {
        SHA1 cloned = (SHA1)this.cloneStateBase();
        cloned.H = Arrays.copyOf(this.H, this.H.length);
        return cloned;
    }

    @Override
    public void reset() {
        super.reset();
        this.H[0] = 1732584193;
        this.H[1] = -271733879;
        this.H[2] = -1732584194;
        this.H[3] = 271733878;
        this.H[4] = -1009589776;
    }

    @Override
    public Binary getHash() {
        this.finish();
        Binary hash = new Binary().reserve(20);
        int[] nArray = this.H;
        int n = this.H.length;
        int n2 = 0;
        while (n2 < n) {
            int h = nArray[n2];
            hash.addInt(h);
            ++n2;
        }
        return hash;
    }

    private void finish() {
        this.tail.add(128);
        if (this.tail.size() > 56) {
            this.tail.resize(64);
            this.processBlock(this.tail, 0);
            this.tail.clear();
        }
        this.tail.resize(64);
        this.tail.setLongBE(this.tail.size() - 8, this.processedBytes << 3);
        this.processBlock(this.tail, 0);
    }

    @Override
    protected void processBlock(Binary data, int offset) {
        int temp;
        byte[] buf = data.getDataRef();
        int j = 0;
        while (j < 16) {
            this.W[j] = buf[offset] << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
            offset += 4;
            ++j;
        }
        j = 16;
        while (j < 80) {
            int a = this.W[j - 3] ^ this.W[j - 8] ^ this.W[j - 14] ^ this.W[j - 16];
            this.W[j] = Integer.rotateLeft(a, 1);
            ++j;
        }
        int A = this.H[0];
        int B = this.H[1];
        int C = this.H[2];
        int D = this.H[3];
        int E = this.H[4];
        int j2 = 0;
        while (j2 < 20) {
            temp = 1518500249 + (A << 5 | A >>> 27) + (B & C | ~B & D) + E + this.W[j2];
            E = D;
            D = C;
            C = Integer.rotateRight(B, 2);
            B = A;
            A = temp;
            ++j2;
        }
        j2 = 20;
        while (j2 < 40) {
            temp = 1859775393 + (A << 5 | A >>> 27) + (B ^ C ^ D) + E + this.W[j2];
            E = D;
            D = C;
            C = Integer.rotateRight(B, 2);
            B = A;
            A = temp;
            ++j2;
        }
        j2 = 40;
        while (j2 < 60) {
            temp = -1894007588 + (A << 5 | A >>> 27) + (B & C | B & D | C & D) + E + this.W[j2];
            E = D;
            D = C;
            C = Integer.rotateRight(B, 2);
            B = A;
            A = temp;
            ++j2;
        }
        j2 = 60;
        while (j2 < 80) {
            temp = -899497514 + (A << 5 | A >>> 27) + (B ^ C ^ D) + E + this.W[j2];
            E = D;
            D = C;
            C = Integer.rotateRight(B, 2);
            B = A;
            A = temp;
            ++j2;
        }
        this.H[0] = this.H[0] + A;
        this.H[1] = this.H[1] + B;
        this.H[2] = this.H[2] + C;
        this.H[3] = this.H[3] + D;
        this.H[4] = this.H[4] + E;
    }
}

