/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.hash;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.crypt.hash.IHash;

public class SHA256
extends IHash {
    public static final int HASH_SIZE = 32;
    private static final int BLOCK_SIZE = 64;
    private int[] W = new int[64];
    protected int[] H = new int[8];
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    public SHA256() {
        super(64);
        this.reset();
    }

    @Override
    public String name() {
        return "SHA-256";
    }

    @Override
    public int size() {
        return 32;
    }

    @Override
    public SHA256 clone() {
        return new SHA256();
    }

    @Override
    public SHA256 cloneState() {
        SHA256 cloned = (SHA256)this.cloneStateBase();
        cloned.H = Arrays.copyOf(this.H, this.H.length);
        return cloned;
    }

    @Override
    public void reset() {
        super.reset();
        this.H[0] = 1779033703;
        this.H[1] = -1150833019;
        this.H[2] = 1013904242;
        this.H[3] = -1521486534;
        this.H[4] = 1359893119;
        this.H[5] = -1694144372;
        this.H[6] = 528734635;
        this.H[7] = 1541459225;
    }

    @Override
    public Binary getHash() {
        this.finish();
        Binary hash = new Binary().reserve(32);
        int[] nArray = this.H;
        int n = this.H.length;
        int n2 = 0;
        while (n2 < n) {
            int h = nArray[n2];
            hash.addInt(h);
            ++n2;
        }
        this.reset();
        return hash;
    }

    private void finish() {
        this.tail.add(128);
        if (this.tail.size() > 56) {
            this.tail.resize(64);
            this.processBlock(this.tail, 0);
            this.tail.clear();
        }
        this.tail.resize(64);
        this.tail.setLongBE(this.tail.size() - 8, this.processedBytes << 3);
        this.processBlock(this.tail, 0);
    }

    @Override
    protected void processBlock(Binary data, int offset) {
        int t1;
        int t2;
        int a = this.H[0];
        int b = this.H[1];
        int c = this.H[2];
        int d = this.H[3];
        int e = this.H[4];
        int f = this.H[5];
        int g = this.H[6];
        int h = this.H[7];
        byte[] buf = data.getDataRef();
        int j = 0;
        while (j < 16) {
            this.W[j] = buf[offset++] << 24 | (buf[offset++] & 0xFF) << 16 | (buf[offset++] & 0xFF) << 8 | buf[offset++] & 0xFF;
            t2 = (Integer.rotateRight(a, 2) ^ Integer.rotateRight(a, 13) ^ Integer.rotateRight(a, 22)) + (a & b ^ a & c ^ b & c);
            t1 = h + (Integer.rotateRight(e, 6) ^ Integer.rotateRight(e, 11) ^ Integer.rotateRight(e, 25)) + (e & f ^ ~e & g) + K[j] + this.W[j];
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
            ++j;
        }
        j = 16;
        while (j < 64) {
            this.W[j] = this.W[j - 16] + (Integer.rotateRight(this.W[j - 15], 7) ^ Integer.rotateRight(this.W[j - 15], 18) ^ this.W[j - 15] >>> 3) + this.W[j - 7] + (Integer.rotateRight(this.W[j - 2], 17) ^ Integer.rotateRight(this.W[j - 2], 19) ^ this.W[j - 2] >>> 10);
            t2 = (Integer.rotateRight(a, 2) ^ Integer.rotateRight(a, 13) ^ Integer.rotateRight(a, 22)) + (a & b ^ a & c ^ b & c);
            t1 = h + (Integer.rotateRight(e, 6) ^ Integer.rotateRight(e, 11) ^ Integer.rotateRight(e, 25)) + (e & f ^ ~e & g) + K[j] + this.W[j];
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
            ++j;
        }
        this.H[0] = this.H[0] + a;
        this.H[1] = this.H[1] + b;
        this.H[2] = this.H[2] + c;
        this.H[3] = this.H[3] + d;
        this.H[4] = this.H[4] + e;
        this.H[5] = this.H[5] + f;
        this.H[6] = this.H[6] + g;
        this.H[7] = this.H[7] + h;
    }
}

