/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.hash;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.crypt.hash.IHash;

public class SHA512
extends IHash {
    public static final int HASH_SIZE = 64;
    private static final int BLOCK_SIZE = 128;
    protected long[] W = new long[80];
    protected long[] H = new long[8];
    private static final long[] CONSTANTS = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};

    public SHA512() {
        super(128);
        this.reset();
    }

    protected SHA512(int dummy) {
        super(128);
    }

    @Override
    public String name() {
        return "SHA-512";
    }

    @Override
    public int size() {
        return 64;
    }

    @Override
    public SHA512 clone() {
        return new SHA512();
    }

    @Override
    public SHA512 cloneState() {
        SHA512 cloned = (SHA512)super.cloneStateBase();
        cloned.H = Arrays.copyOf(this.H, this.H.length);
        return cloned;
    }

    @Override
    public void reset() {
        super.reset();
        this.H[0] = 7640891576956012808L;
        this.H[1] = -4942790177534073029L;
        this.H[2] = 4354685564936845355L;
        this.H[3] = -6534734903238641935L;
        this.H[4] = 5840696475078001361L;
        this.H[5] = -7276294671716946913L;
        this.H[6] = 2270897969802886507L;
        this.H[7] = 6620516959819538809L;
    }

    @Override
    public Binary getHash() {
        this.finish();
        Binary hash = new Binary().reserve(64);
        long[] lArray = this.H;
        int n = this.H.length;
        int n2 = 0;
        while (n2 < n) {
            long h = lArray[n2];
            hash.addLong(h);
            ++n2;
        }
        this.reset();
        return hash;
    }

    protected void finish() {
        this.tail.add(128);
        if (this.tail.size() > 112) {
            this.tail.resize(128);
            this.processBlock(this.tail, 0);
            this.tail.clear();
        }
        this.tail.resize(128);
        this.tail.setLongBE(this.tail.size() - 16, this.processedBytes >>> 61);
        this.tail.setLongBE(this.tail.size() - 8, this.processedBytes << 3);
        this.processBlock(this.tail, 0);
    }

    @Override
    protected void processBlock(Binary data, int offset) {
        long t1;
        long ch;
        long s0;
        long a = this.H[0];
        long b = this.H[1];
        long c = this.H[2];
        long d = this.H[3];
        long e = this.H[4];
        long f = this.H[5];
        long g = this.H[6];
        long h = this.H[7];
        int j = 0;
        while (j < 16) {
            this.W[j] = data.getLongBE(offset);
            s0 = Long.rotateRight(a, 28) ^ Long.rotateRight(a, 34) ^ Long.rotateRight(a, 39);
            long ma = a & b ^ a & c ^ b & c;
            long t2 = s0 + ma;
            long s1 = Long.rotateRight(e, 14) ^ Long.rotateRight(e, 18) ^ Long.rotateRight(e, 41);
            ch = e & f ^ (e ^ 0xFFFFFFFFFFFFFFFFL) & g;
            t1 = h + s1 + ch + CONSTANTS[j] + this.W[j];
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
            ++j;
            offset += 8;
        }
        j = 16;
        while (j < 80) {
            s0 = Long.rotateRight(this.W[j - 15], 1) ^ Long.rotateRight(this.W[j - 15], 8) ^ this.W[j - 15] >>> 7;
            long s1 = Long.rotateRight(this.W[j - 2], 19) ^ Long.rotateRight(this.W[j - 2], 61) ^ this.W[j - 2] >>> 6;
            this.W[j] = this.W[j - 16] + s0 + this.W[j - 7] + s1;
            s0 = Long.rotateRight(a, 28) ^ Long.rotateRight(a, 34) ^ Long.rotateRight(a, 39);
            long ma = a & b ^ a & c ^ b & c;
            long t2 = s0 + ma;
            s1 = Long.rotateRight(e, 14) ^ Long.rotateRight(e, 18) ^ Long.rotateRight(e, 41);
            ch = e & f ^ (e ^ 0xFFFFFFFFFFFFFFFFL) & g;
            t1 = h + s1 + ch + CONSTANTS[j] + this.W[j];
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
            ++j;
        }
        this.H[0] = this.H[0] + a;
        this.H[1] = this.H[1] + b;
        this.H[2] = this.H[2] + c;
        this.H[3] = this.H[3] + d;
        this.H[4] = this.H[4] + e;
        this.H[5] = this.H[5] + f;
        this.H[6] = this.H[6] + g;
        this.H[7] = this.H[7] + h;
    }
}

