/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.streamcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.streamcipher.Salsa20;

public class ChaCha
extends Salsa20 {
    public ChaCha() {
    }

    public ChaCha(int rounds) {
        super(rounds);
    }

    public ChaCha(int rounds, Binary key) {
        super(rounds, key);
    }

    @Override
    public String getAlgName() {
        return "ChaCha" + this.rounds;
    }

    @Override
    public Salsa20 startEncrypt(Binary iv) {
        Ex.MUST(iv != null && iv.size() == 8, "Wrong IV size");
        this.initChaCha(iv);
        this.reset();
        return this;
    }

    @Override
    public Salsa20 startDecrypt(Binary iv) {
        Ex.MUST(iv != null && iv.size() == 8, "Wrong IV size");
        this.initChaCha(iv);
        this.reset();
        return this;
    }

    private void initChaCha(Binary iv) {
        this.packTauOrSigma(this.key.size(), this.engineState, 0);
        ChaCha.littleEndianToInt(this.key.getDataRef(), 0, this.engineState, 4, 4);
        ChaCha.littleEndianToInt(this.key.getDataRef(), this.key.size() - 16, this.engineState, 8, 4);
        ChaCha.littleEndianToInt(iv.getDataRef(), 0, this.engineState, 14, 2);
    }

    @Override
    protected void advanceCounter(long diff) {
        int hi = (int)(diff >>> 32);
        int lo = (int)diff;
        if (hi > 0) {
            this.engineState[13] = this.engineState[13] + hi;
        }
        int oldState = this.engineState[12];
        this.engineState[12] = this.engineState[12] + lo;
        if (oldState != 0 && this.engineState[12] < oldState) {
            this.engineState[13] = this.engineState[13] + 1;
        }
    }

    @Override
    protected void advanceCounter() {
        this.engineState[12] = this.engineState[12] + 1;
        if (this.engineState[12] == 0) {
            this.engineState[13] = this.engineState[13] + 1;
        }
    }

    @Override
    protected void retreatCounter(long diff) {
        int hi = (int)(diff >>> 32);
        int lo = (int)diff;
        if (hi != 0) {
            Ex.MUST(((long)this.engineState[13] & 0xFFFFFFFFL) >= ((long)hi & 0xFFFFFFFFL), "attempt to reduce counter past zero.");
            this.engineState[13] = this.engineState[13] - hi;
        }
        if (((long)this.engineState[12] & 0xFFFFFFFFL) >= ((long)lo & 0xFFFFFFFFL)) {
            this.engineState[12] = this.engineState[12] - lo;
        } else {
            Ex.MUST(this.engineState[13] != 0, "attempt to reduce counter past zero.");
            this.engineState[13] = this.engineState[13] - 1;
            this.engineState[12] = this.engineState[12] - lo;
        }
    }

    @Override
    protected void retreatCounter() {
        Ex.MUST(this.engineState[12] != 0 || this.engineState[13] != 0, "attempt to reduce counter past zero.");
        this.engineState[12] = this.engineState[12] - 1;
        if (this.engineState[12] == -1) {
            this.engineState[13] = this.engineState[13] - 1;
        }
    }

    @Override
    protected long getCounter() {
        return (long)this.engineState[13] << 32 | (long)this.engineState[12] & 0xFFFFFFFFL;
    }

    @Override
    protected void resetCounter() {
        this.engineState[12] = 0;
        this.engineState[13] = 0;
    }

    @Override
    protected void generateKeyStream(byte[] output) {
        ChaCha.chachaCore(this.rounds, this.engineState, this.x);
        ChaCha.intToLittleEndian(this.x, output, 0);
    }

    static void chachaCore(int rounds, int[] input, int[] x) {
        int x00 = input[0];
        int x01 = input[1];
        int x02 = input[2];
        int x03 = input[3];
        int x04 = input[4];
        int x05 = input[5];
        int x06 = input[6];
        int x07 = input[7];
        int x08 = input[8];
        int x09 = input[9];
        int x10 = input[10];
        int x11 = input[11];
        int x12 = input[12];
        int x13 = input[13];
        int x14 = input[14];
        int x15 = input[15];
        int i = rounds;
        while (i > 0) {
            x12 = Integer.rotateLeft(x12 ^ (x00 += x04), 16);
            x04 = Integer.rotateLeft(x04 ^ (x08 += x12), 12);
            x12 = Integer.rotateLeft(x12 ^ (x00 += x04), 8);
            x04 = Integer.rotateLeft(x04 ^ (x08 += x12), 7);
            x13 = Integer.rotateLeft(x13 ^ (x01 += x05), 16);
            x05 = Integer.rotateLeft(x05 ^ (x09 += x13), 12);
            x13 = Integer.rotateLeft(x13 ^ (x01 += x05), 8);
            x05 = Integer.rotateLeft(x05 ^ (x09 += x13), 7);
            x14 = Integer.rotateLeft(x14 ^ (x02 += x06), 16);
            x06 = Integer.rotateLeft(x06 ^ (x10 += x14), 12);
            x14 = Integer.rotateLeft(x14 ^ (x02 += x06), 8);
            x06 = Integer.rotateLeft(x06 ^ (x10 += x14), 7);
            x15 = Integer.rotateLeft(x15 ^ (x03 += x07), 16);
            x07 = Integer.rotateLeft(x07 ^ (x11 += x15), 12);
            x15 = Integer.rotateLeft(x15 ^ (x03 += x07), 8);
            x07 = Integer.rotateLeft(x07 ^ (x11 += x15), 7);
            x15 = Integer.rotateLeft(x15 ^ (x00 += x05), 16);
            x05 = Integer.rotateLeft(x05 ^ (x10 += x15), 12);
            x15 = Integer.rotateLeft(x15 ^ (x00 += x05), 8);
            x05 = Integer.rotateLeft(x05 ^ (x10 += x15), 7);
            x12 = Integer.rotateLeft(x12 ^ (x01 += x06), 16);
            x06 = Integer.rotateLeft(x06 ^ (x11 += x12), 12);
            x12 = Integer.rotateLeft(x12 ^ (x01 += x06), 8);
            x06 = Integer.rotateLeft(x06 ^ (x11 += x12), 7);
            x13 = Integer.rotateLeft(x13 ^ (x02 += x07), 16);
            x07 = Integer.rotateLeft(x07 ^ (x08 += x13), 12);
            x13 = Integer.rotateLeft(x13 ^ (x02 += x07), 8);
            x07 = Integer.rotateLeft(x07 ^ (x08 += x13), 7);
            x14 = Integer.rotateLeft(x14 ^ (x03 += x04), 16);
            x04 = Integer.rotateLeft(x04 ^ (x09 += x14), 12);
            x14 = Integer.rotateLeft(x14 ^ (x03 += x04), 8);
            x04 = Integer.rotateLeft(x04 ^ (x09 += x14), 7);
            i -= 2;
        }
        x[0] = x00 + input[0];
        x[1] = x01 + input[1];
        x[2] = x02 + input[2];
        x[3] = x03 + input[3];
        x[4] = x04 + input[4];
        x[5] = x05 + input[5];
        x[6] = x06 + input[6];
        x[7] = x07 + input[7];
        x[8] = x08 + input[8];
        x[9] = x09 + input[9];
        x[10] = x10 + input[10];
        x[11] = x11 + input[11];
        x[12] = x12 + input[12];
        x[13] = x13 + input[13];
        x[14] = x14 + input[14];
        x[15] = x15 + input[15];
    }
}

