/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.streamcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.streamcipher.ChaCha;
import org.denom.crypt.streamcipher.Salsa20;

public class ChaCha7539
extends Salsa20 {
    public ChaCha7539() {
    }

    public ChaCha7539(int rounds) {
        super(rounds);
    }

    public ChaCha7539(int rounds, Binary key) {
        super(rounds, key);
    }

    @Override
    public String getAlgName() {
        return "ChaCha7539-" + this.rounds;
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 32, "Wrong key size");
        this.key = key.clone();
    }

    @Override
    public ChaCha7539 startEncrypt(Binary iv) {
        Ex.MUST(iv != null && iv.size() == 12, "Wrong IV size");
        this.initChaCha7539(iv);
        this.reset();
        return this;
    }

    @Override
    public ChaCha7539 startDecrypt(Binary iv) {
        Ex.MUST(iv != null && iv.size() == 12, "Wrong IV size");
        this.initChaCha7539(iv);
        this.reset();
        return this;
    }

    private void initChaCha7539(Binary iv) {
        this.packTauOrSigma(this.key.size(), this.engineState, 0);
        ChaCha7539.littleEndianToInt(this.key.getDataRef(), 0, this.engineState, 4, 8);
        ChaCha7539.littleEndianToInt(iv.getDataRef(), 0, this.engineState, 13, 3);
    }

    @Override
    protected void advanceCounter(long diff) {
        int hi = (int)(diff >>> 32);
        int lo = (int)diff;
        Ex.MUST(hi == 0, "attempt to increase counter past 2^32.");
        int oldState = this.engineState[12];
        this.engineState[12] = this.engineState[12] + lo;
        if (oldState != 0 && this.engineState[12] < oldState) {
            throw new IllegalStateException("attempt to increase counter past 2^32.");
        }
    }

    @Override
    protected void advanceCounter() {
        this.engineState[12] = this.engineState[12] + 1;
        Ex.MUST(this.engineState[12] != 0, "attempt to increase counter past 2^32.");
    }

    @Override
    protected void retreatCounter(long diff) {
        int hi = (int)(diff >>> 32);
        int lo = (int)diff;
        if (hi != 0) {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        if (((long)this.engineState[12] & 0xFFFFFFFFL) < ((long)lo & 0xFFFFFFFFL)) {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        this.engineState[12] = this.engineState[12] - lo;
    }

    @Override
    protected void retreatCounter() {
        if (this.engineState[12] == 0) {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        this.engineState[12] = this.engineState[12] - 1;
    }

    @Override
    protected long getCounter() {
        return (long)this.engineState[12] & 0xFFFFFFFFL;
    }

    @Override
    protected void resetCounter() {
        this.engineState[12] = 0;
    }

    @Override
    protected void generateKeyStream(byte[] output) {
        ChaCha.chachaCore(this.rounds, this.engineState, this.x);
        ChaCha7539.intToLittleEndian(this.x, output, 0);
    }
}

