/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.streamcipher;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.streamcipher.StreamCipher;

public class ISAAC
extends StreamCipher {
    private int[] state = new int[256];
    private int[] results = new int[256];
    private byte[] keyStream = new byte[1024];
    private int index = 0;
    private int a = 0;
    private int b = 0;
    private int c = 0;
    private byte[] tKey;

    public ISAAC() {
        this(Binary.Bin(16));
    }

    public ISAAC(Binary key) {
        this.setKey(key);
    }

    @Override
    public String getAlgName() {
        return "ISAAC";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() >= 1 && key.size() <= 1024, "Wrong key size");
        this.key = key.clone();
        this.tKey = new byte[key.size() + 3 & 0xFFFFFFFC];
        System.arraycopy(key.getDataRef(), 0, this.tKey, 0, key.size());
        this.init();
    }

    private void init() {
        Arrays.fill(this.state, 0);
        this.a = 0;
        this.b = 0;
        this.c = 0;
        this.index = 0;
        Arrays.fill(this.results, 0);
        int i = 0;
        while (i < this.tKey.length) {
            this.results[i >>> 2] = Binary.getIntLE(this.tKey, i);
            i += 4;
        }
        int[] abcdefgh = new int[8];
        int i2 = 0;
        while (i2 < 8) {
            abcdefgh[i2] = -1640531527;
            ++i2;
        }
        i2 = 0;
        while (i2 < 4) {
            this.mix(abcdefgh);
            ++i2;
        }
        i2 = 0;
        while (i2 < 2) {
            int j = 0;
            while (j < this.state.length) {
                int k = 0;
                while (k < 8) {
                    int n = k;
                    abcdefgh[n] = abcdefgh[n] + (i2 < 1 ? this.results[j + k] : this.state[j + k]);
                    ++k;
                }
                this.mix(abcdefgh);
                k = 0;
                while (k < 8) {
                    this.state[j + k] = abcdefgh[k];
                    ++k;
                }
                j += 8;
            }
            ++i2;
        }
        this.isaac();
    }

    @Override
    public ISAAC startEncrypt(Binary iv) {
        this.init();
        return this;
    }

    @Override
    public ISAAC startDecrypt(Binary iv) {
        this.init();
        return this;
    }

    @Override
    public byte process(byte in) {
        if (this.index == 0) {
            this.isaac();
            int i = 0;
            while (i < this.results.length) {
                Binary.setIntBE(this.keyStream, i << 2, this.results[i]);
                ++i;
            }
        }
        byte out = (byte)(this.keyStream[this.index] ^ in);
        this.index = this.index + 1 & 0x3FF;
        return out;
    }

    private void isaac() {
        ++this.c;
        this.b += this.c;
        int i = 0;
        while (i < this.results.length) {
            int y;
            int x = this.state[i];
            switch (i & 3) {
                case 0: {
                    this.a ^= this.a << 13;
                    break;
                }
                case 1: {
                    this.a ^= this.a >>> 6;
                    break;
                }
                case 2: {
                    this.a ^= this.a << 2;
                    break;
                }
                case 3: {
                    this.a ^= this.a >>> 16;
                }
            }
            this.a += this.state[i + 128 & 0xFF];
            this.state[i] = y = this.state[x >>> 2 & 0xFF] + this.a + this.b;
            this.results[i] = this.b = this.state[y >>> 10 & 0xFF] + x;
            ++i;
        }
    }

    private void mix(int[] x) {
        x[0] = x[0] ^ x[1] << 11;
        x[3] = x[3] + x[0];
        x[1] = x[1] + x[2];
        x[1] = x[1] ^ x[2] >>> 2;
        x[4] = x[4] + x[1];
        x[2] = x[2] + x[3];
        x[2] = x[2] ^ x[3] << 8;
        x[5] = x[5] + x[2];
        x[3] = x[3] + x[4];
        x[3] = x[3] ^ x[4] >>> 16;
        x[6] = x[6] + x[3];
        x[4] = x[4] + x[5];
        x[4] = x[4] ^ x[5] << 10;
        x[7] = x[7] + x[4];
        x[5] = x[5] + x[6];
        x[5] = x[5] ^ x[6] >>> 4;
        x[0] = x[0] + x[5];
        x[6] = x[6] + x[7];
        x[6] = x[6] ^ x[7] << 8;
        x[1] = x[1] + x[6];
        x[7] = x[7] + x[0];
        x[7] = x[7] ^ x[0] >>> 9;
        x[2] = x[2] + x[7];
        x[0] = x[0] + x[1];
    }
}

