/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.streamcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.streamcipher.StreamCipher;

public class RC4
extends StreamCipher {
    private byte[] state = new byte[256];
    private int x = 0;
    private int y = 0;

    public RC4() {
        this(Binary.Bin(16));
    }

    public RC4(Binary key) {
        this.setKey(key);
    }

    @Override
    public String getAlgName() {
        return "RC4";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() >= 5 && key.size() <= 256, "Wrong key size");
        this.key = key.clone();
    }

    private void init() {
        byte[] keyArr = this.key.getDataRef();
        int keyLen = this.key.size();
        this.x = 0;
        this.y = 0;
        int i = 0;
        while (i < this.state.length) {
            this.state[i] = (byte)i;
            ++i;
        }
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        while (i3 < this.state.length) {
            i2 = (keyArr[i1] & 0xFF) + this.state[i3] + i2 & 0xFF;
            byte tmp = this.state[i3];
            this.state[i3] = this.state[i2];
            this.state[i2] = tmp;
            i1 = (i1 + 1) % keyLen;
            ++i3;
        }
    }

    @Override
    public RC4 startEncrypt(Binary iv) {
        this.init();
        return this;
    }

    @Override
    public RC4 startDecrypt(Binary iv) {
        this.init();
        return this;
    }

    @Override
    public byte process(byte in) {
        this.x = this.x + 1 & 0xFF;
        this.y = this.state[this.x] + this.y & 0xFF;
        byte tmp = this.state[this.x];
        this.state[this.x] = this.state[this.y];
        this.state[this.y] = tmp;
        return (byte)(in ^ this.state[this.state[this.x] + this.state[this.y] & 0xFF]);
    }
}

