/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.streamcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.streamcipher.StreamCipher;

public class Salsa20
extends StreamCipher {
    public static final int DEFAULT_ROUNDS = 20;
    private static final int[] TAU_SIGMA = Salsa20.littleEndianToInt("expand 16-byte kexpand 32-byte k".getBytes(), 0, 8);
    protected int rounds;
    private int index = 0;
    protected int[] engineState = new int[16];
    protected int[] x = new int[16];
    private byte[] keyStream = new byte[64];

    protected void packTauOrSigma(int keyLength, int[] state, int stateOffset) {
        int tsOff = (keyLength - 16) / 4;
        state[stateOffset] = TAU_SIGMA[tsOff];
        state[stateOffset + 1] = TAU_SIGMA[tsOff + 1];
        state[stateOffset + 2] = TAU_SIGMA[tsOff + 2];
        state[stateOffset + 3] = TAU_SIGMA[tsOff + 3];
    }

    public Salsa20() {
        this(20, Binary.Bin(16));
    }

    public Salsa20(int rounds) {
        this(rounds, Binary.Bin(16));
    }

    public Salsa20(int rounds, Binary key) {
        Ex.MUST(rounds > 1 && (rounds & 1) == 0, "'rounds' must be a positive, even number");
        this.rounds = rounds;
        this.setKey(key);
    }

    @Override
    public String getAlgName() {
        String name = "Salsa20";
        if (this.rounds != 20) {
            name = String.valueOf(name) + "/" + this.rounds;
        }
        return name;
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 16 || key.size() == 32, "Wrong key size");
        this.key = key.clone();
    }

    @Override
    public Salsa20 startEncrypt(Binary iv) {
        Ex.MUST(iv != null && iv.size() == 8, "Wrong IV size");
        this.initSalsa(iv);
        this.reset();
        return this;
    }

    @Override
    public Salsa20 startDecrypt(Binary iv) {
        Ex.MUST(iv != null && iv.size() == 8, "Wrong IV size");
        this.initSalsa(iv);
        this.reset();
        return this;
    }

    protected void initSalsa(Binary iv) {
        int tsOff = (this.key.size() - 16) / 4;
        this.engineState[0] = TAU_SIGMA[tsOff];
        this.engineState[5] = TAU_SIGMA[tsOff + 1];
        this.engineState[10] = TAU_SIGMA[tsOff + 2];
        this.engineState[15] = TAU_SIGMA[tsOff + 3];
        Salsa20.littleEndianToInt(this.key.getDataRef(), 0, this.engineState, 1, 4);
        Salsa20.littleEndianToInt(this.key.getDataRef(), this.key.size() - 16, this.engineState, 11, 4);
        Salsa20.littleEndianToInt(iv.getDataRef(), 0, this.engineState, 6, 2);
    }

    @Override
    public byte process(byte in) {
        byte out = (byte)(this.keyStream[this.index] ^ in);
        this.index = this.index + 1 & 0x3F;
        if (this.index == 0) {
            this.advanceCounter();
            this.generateKeyStream(this.keyStream);
        }
        return out;
    }

    protected void advanceCounter(long diff) {
        int hi = (int)(diff >>> 32);
        int lo = (int)diff;
        if (hi > 0) {
            this.engineState[9] = this.engineState[9] + hi;
        }
        int oldState = this.engineState[8];
        this.engineState[8] = this.engineState[8] + lo;
        if (oldState != 0 && this.engineState[8] < oldState) {
            this.engineState[9] = this.engineState[9] + 1;
        }
    }

    protected void advanceCounter() {
        this.engineState[8] = this.engineState[8] + 1;
        if (this.engineState[8] == 0) {
            this.engineState[9] = this.engineState[9] + 1;
        }
    }

    protected void retreatCounter(long diff) {
        int hi = (int)(diff >>> 32);
        int lo = (int)diff;
        if (hi != 0) {
            Ex.MUST(((long)this.engineState[9] & 0xFFFFFFFFL) >= ((long)hi & 0xFFFFFFFFL), "attempt to reduce counter past zero.");
            this.engineState[9] = this.engineState[9] - hi;
        }
        if (((long)this.engineState[8] & 0xFFFFFFFFL) >= ((long)lo & 0xFFFFFFFFL)) {
            this.engineState[8] = this.engineState[8] - lo;
        } else {
            Ex.MUST(this.engineState[9] != 0, "attempt to reduce counter past zero.");
            this.engineState[9] = this.engineState[9] - 1;
            this.engineState[8] = this.engineState[8] - lo;
        }
    }

    protected void retreatCounter() {
        Ex.MUST(this.engineState[8] != 0 || this.engineState[9] != 0, "attempt to reduce counter past zero.");
        this.engineState[8] = this.engineState[8] - 1;
        if (this.engineState[8] == -1) {
            this.engineState[9] = this.engineState[9] - 1;
        }
    }

    public long skip(long numberOfBytes) {
        if (numberOfBytes >= 0L) {
            long remaining = numberOfBytes;
            if (remaining >= 64L) {
                long count = remaining / 64L;
                this.advanceCounter(count);
                remaining -= count * 64L;
            }
            int oldIndex = this.index;
            this.index = this.index + (int)remaining & 0x3F;
            if (this.index < oldIndex) {
                this.advanceCounter();
            }
        } else {
            long remaining = -numberOfBytes;
            if (remaining >= 64L) {
                long count = remaining / 64L;
                this.retreatCounter(count);
                remaining -= count * 64L;
            }
            long i = 0L;
            while (i < remaining) {
                if (this.index == 0) {
                    this.retreatCounter();
                }
                this.index = this.index - 1 & 0x3F;
                ++i;
            }
        }
        this.generateKeyStream(this.keyStream);
        return numberOfBytes;
    }

    public long seekTo(long position) {
        this.reset();
        return this.skip(position);
    }

    public long getPosition() {
        return this.getCounter() * 64L + (long)this.index;
    }

    public void reset() {
        this.index = 0;
        this.resetCounter();
        this.generateKeyStream(this.keyStream);
    }

    protected long getCounter() {
        return (long)this.engineState[9] << 32 | (long)this.engineState[8] & 0xFFFFFFFFL;
    }

    protected void resetCounter() {
        this.engineState[9] = 0;
        this.engineState[8] = 0;
    }

    protected void generateKeyStream(byte[] output) {
        Salsa20.salsaCore(this.rounds, this.engineState, this.x);
        Salsa20.intToLittleEndian(this.x, output, 0);
    }

    static void salsaCore(int rounds, int[] input, int[] x) {
        Ex.MUST(input.length == 16);
        Ex.MUST(x.length == 16);
        Ex.MUST(rounds % 2 == 0);
        int x00 = input[0];
        int x01 = input[1];
        int x02 = input[2];
        int x03 = input[3];
        int x04 = input[4];
        int x05 = input[5];
        int x06 = input[6];
        int x07 = input[7];
        int x08 = input[8];
        int x09 = input[9];
        int x10 = input[10];
        int x11 = input[11];
        int x12 = input[12];
        int x13 = input[13];
        int x14 = input[14];
        int x15 = input[15];
        int i = rounds;
        while (i > 0) {
            x08 ^= Integer.rotateLeft((x04 ^= Integer.rotateLeft(x00 + x12, 7)) + x00, 9);
            x00 ^= Integer.rotateLeft((x12 ^= Integer.rotateLeft(x08 + x04, 13)) + x08, 18);
            x13 ^= Integer.rotateLeft((x09 ^= Integer.rotateLeft(x05 + x01, 7)) + x05, 9);
            x05 ^= Integer.rotateLeft((x01 ^= Integer.rotateLeft(x13 + x09, 13)) + x13, 18);
            x02 ^= Integer.rotateLeft((x14 ^= Integer.rotateLeft(x10 + x06, 7)) + x10, 9);
            x10 ^= Integer.rotateLeft((x06 ^= Integer.rotateLeft(x02 + x14, 13)) + x02, 18);
            x07 ^= Integer.rotateLeft((x03 ^= Integer.rotateLeft(x15 + x11, 7)) + x15, 9);
            x15 ^= Integer.rotateLeft((x11 ^= Integer.rotateLeft(x07 + x03, 13)) + x07, 18);
            x02 ^= Integer.rotateLeft((x01 ^= Integer.rotateLeft(x00 + x03, 7)) + x00, 9);
            x00 ^= Integer.rotateLeft((x03 ^= Integer.rotateLeft(x02 + x01, 13)) + x02, 18);
            x07 ^= Integer.rotateLeft((x06 ^= Integer.rotateLeft(x05 + x04, 7)) + x05, 9);
            x05 ^= Integer.rotateLeft((x04 ^= Integer.rotateLeft(x07 + x06, 13)) + x07, 18);
            x08 ^= Integer.rotateLeft((x11 ^= Integer.rotateLeft(x10 + x09, 7)) + x10, 9);
            x10 ^= Integer.rotateLeft((x09 ^= Integer.rotateLeft(x08 + x11, 13)) + x08, 18);
            x13 ^= Integer.rotateLeft((x12 ^= Integer.rotateLeft(x15 + x14, 7)) + x15, 9);
            x15 ^= Integer.rotateLeft((x14 ^= Integer.rotateLeft(x13 + x12, 13)) + x13, 18);
            i -= 2;
        }
        x[0] = x00 + input[0];
        x[1] = x01 + input[1];
        x[2] = x02 + input[2];
        x[3] = x03 + input[3];
        x[4] = x04 + input[4];
        x[5] = x05 + input[5];
        x[6] = x06 + input[6];
        x[7] = x07 + input[7];
        x[8] = x08 + input[8];
        x[9] = x09 + input[9];
        x[10] = x10 + input[10];
        x[11] = x11 + input[11];
        x[12] = x12 + input[12];
        x[13] = x13 + input[13];
        x[14] = x14 + input[14];
        x[15] = x15 + input[15];
    }

    protected static void littleEndianToInt(byte[] bs, int bOff, int[] ns, int nOff, int count) {
        int i = 0;
        while (i < count) {
            ns[nOff + i] = Binary.getIntLE(bs, bOff);
            bOff += 4;
            ++i;
        }
    }

    protected static int[] littleEndianToInt(byte[] bs, int off, int count) {
        int[] ns = new int[count];
        int i = 0;
        while (i < ns.length) {
            ns[i] = Binary.getIntLE(bs, off);
            off += 4;
            ++i;
        }
        return ns;
    }

    protected static void intToLittleEndian(int[] ns, byte[] bs, int off) {
        int i = 0;
        while (i < ns.length) {
            Binary.setIntLE(bs, off, ns[i]);
            off += 4;
            ++i;
        }
    }
}

