/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.streamcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.streamcipher.Salsa20;

public class XSalsa20
extends Salsa20 {
    public XSalsa20() {
        super(20, Binary.Bin(32));
    }

    public XSalsa20(Binary key) {
        super(20, key);
    }

    @Override
    public String getAlgName() {
        return "XSalsa20";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 32, "Wrong key size");
        this.key = key.clone();
    }

    @Override
    public XSalsa20 startEncrypt(Binary iv) {
        Ex.MUST(iv != null && iv.size() == 24, "Wrong IV size");
        this.initXSalsa(iv);
        this.reset();
        return this;
    }

    @Override
    public XSalsa20 startDecrypt(Binary iv) {
        Ex.MUST(iv != null && iv.size() == 24, "Wrong IV size");
        this.initXSalsa(iv);
        this.reset();
        return this;
    }

    private void initXSalsa(Binary iv) {
        super.initSalsa(iv);
        XSalsa20.littleEndianToInt(iv.getDataRef(), 8, this.engineState, 8, 2);
        int[] hsalsa20Out = new int[this.engineState.length];
        XSalsa20.salsaCore(20, this.engineState, hsalsa20Out);
        this.engineState[1] = hsalsa20Out[0] - this.engineState[0];
        this.engineState[2] = hsalsa20Out[5] - this.engineState[5];
        this.engineState[3] = hsalsa20Out[10] - this.engineState[10];
        this.engineState[4] = hsalsa20Out[15] - this.engineState[15];
        this.engineState[11] = hsalsa20Out[6] - this.engineState[6];
        this.engineState[12] = hsalsa20Out[7] - this.engineState[7];
        this.engineState[13] = hsalsa20Out[8] - this.engineState[8];
        this.engineState[14] = hsalsa20Out[9] - this.engineState[9];
        XSalsa20.littleEndianToInt(iv.getDataRef(), 16, this.engineState, 6, 2);
    }
}

