/*
 * Decompiled with CFR 0.152.
 */
package org.denom.ecj;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;

public class JavaCompilerECJ {
    private static final String JAVA_COMPLIANCE = "1.8";
    JavaCompiler javac;
    private MyClassLoader classLoader = new MyClassLoader();
    private Map<String, MemoryByteCode> compiledClasses = new HashMap<String, MemoryByteCode>();

    private static void MUST(boolean expression, String message) {
        if (!expression) {
            throw new RuntimeException(message);
        }
    }

    public JavaCompilerECJ() {
        try {
            this.javac = (JavaCompiler)Class.forName("org.eclipse.jdt.internal.compiler.tool.EclipseCompiler").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new RuntimeException("ECJ compiler not found");
        }
    }

    /*
     * Loose catch block
     */
    private static byte[] loadFile(String fileName) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                byte[] byArray;
                BufferedInputStream bufInputStream;
                FileInputStream fis;
                block18: {
                    block17: {
                        fis = new FileInputStream(fileName);
                        bufInputStream = new BufferedInputStream(fis);
                        int size = bufInputStream.available();
                        JavaCompilerECJ.MUST(size < Integer.MAX_VALUE, "\u0420\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0437\u043c\u0435\u0440\u0430 int");
                        byte[] buf = new byte[size];
                        bufInputStream.read(buf);
                        byArray = buf;
                        if (bufInputStream == null) break block17;
                        bufInputStream.close();
                    }
                    if (fis == null) break block18;
                    fis.close();
                }
                return byArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (bufInputStream != null) {
                                bufInputStream.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Class<?> compile(String srcFilename) {
        StandardJavaFileManager sjfm = this.javac.getStandardFileManager(null, null, null);
        MyJavaFileManager fileManager = new MyJavaFileManager(sjfm);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-1.8");
        options.add("-classpath");
        options.add(System.getProperty("java.class.path"));
        byte[] buf = JavaCompilerECJ.loadFile(srcFilename);
        String sourceCode = new String(buf, 0, buf.length, Charset.forName("UTF-8"));
        MemorySource compilationUnit = new MemorySource(srcFilename.replace("\\", "/"), sourceCode);
        StringWriter out = new StringWriter();
        JavaCompiler.CompilationTask compile = this.javac.getTask(out, fileManager, null, options, null, Arrays.asList(compilationUnit));
        JavaCompilerECJ.MUST(compile.call(), "Ecj compiler error: \n" + out.toString());
        Class<?> compiledClass = null;
        for (Map.Entry<String, MemoryByteCode> entry : this.compiledClasses.entrySet()) {
            Class<?> aClass = this.classLoader.loadClass(entry.getKey(), entry.getValue());
            if (!Modifier.isPublic(aClass.getModifiers())) continue;
            JavaCompilerECJ.MUST(compiledClass == null, "More than one public class");
            compiledClass = aClass;
        }
        this.compiledClasses.clear();
        JavaCompilerECJ.MUST(compiledClass != null, "No public class found");
        return compiledClass;
    }

    public Object getInstance(String srcFilename) {
        try {
            return this.compile(srcFilename).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private class MemoryByteCode
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream baos;

        public MemoryByteCode(String name) {
            super(URI.create("byte:///" + name + ".class"), JavaFileObject.Kind.CLASS);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            throw new IllegalStateException();
        }

        @Override
        public OutputStream openOutputStream() {
            this.baos = new ByteArrayOutputStream();
            return this.baos;
        }

        @Override
        public InputStream openInputStream() {
            throw new IllegalStateException();
        }

        public byte[] getBytes() {
            return this.baos.toByteArray();
        }
    }

    private class MemorySource
    extends SimpleJavaFileObject {
        private String src;

        public MemorySource(String name, String src) {
            super(new File(name).toURI(), JavaFileObject.Kind.SOURCE);
            this.src = src;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.src;
        }

        @Override
        public OutputStream openOutputStream() {
            throw new IllegalStateException();
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.src.getBytes());
        }
    }

    private class MyClassLoader
    extends ClassLoader {
        private MyClassLoader() {
        }

        Class<?> loadClass(String name, MemoryByteCode mbc) {
            return super.defineClass(name, mbc.getBytes(), 0, mbc.getBytes().length);
        }
    }

    private class MyJavaFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        MyJavaFileManager(StandardJavaFileManager sjfm) {
            super(sjfm);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            MemoryByteCode mbc = new MemoryByteCode(name);
            name = name.replace("/", ".");
            JavaCompilerECJ.this.compiledClasses.put(name, mbc);
            return mbc;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return JavaCompilerECJ.this.classLoader;
        }
    }
}

