/*
 * Decompiled with CFR 0.152.
 */
package org.denom.format;

import org.denom.Binary;
import org.denom.Ex;

public class Base64 {
    public static final int MODE_CLASSIC = 1;
    public static final int MODE_URL = 2;
    private final byte paddingByte;
    private final char[] encodeTable;
    private int[] decodeTable = null;
    private static final char[] ENCODE_TABLE_CLASSIC = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char[] ENCODE_TABLE_URL = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};

    public Base64() {
        this(1);
    }

    public Base64(int mode) {
        switch (mode) {
            case 1: {
                this.encodeTable = ENCODE_TABLE_CLASSIC;
                this.paddingByte = (byte)61;
                break;
            }
            case 2: {
                this.encodeTable = ENCODE_TABLE_URL;
                this.paddingByte = (byte)46;
                break;
            }
            default: {
                this.paddingByte = 0;
                this.encodeTable = null;
                this.decodeTable = null;
                Ex.THROW("Unsupported mode for Base64: " + mode);
            }
        }
    }

    public String encode(byte[] arr) {
        int b;
        int len = arr.length;
        if (len == 0) {
            return "";
        }
        StringBuilder encodedStr = new StringBuilder(len * 4 / 3);
        int i = 0;
        while (i + 2 < len) {
            int num = (arr[i] & 0xFF) << 16 | (arr[i + 1] & 0xFF) << 8 | arr[i + 2] & 0xFF;
            encodedStr.append(this.encodeTable[num >> 18]);
            encodedStr.append(this.encodeTable[num >> 12 & 0x3F]);
            encodedStr.append(this.encodeTable[num >> 6 & 0x3F]);
            encodedStr.append(this.encodeTable[num & 0x3F]);
            i += 3;
        }
        if (len - i == 1) {
            b = arr[i] & 0xFF;
            encodedStr.append(this.encodeTable[b >> 2]);
            encodedStr.append(this.encodeTable[b << 4 & 0x3F]);
            encodedStr.append((char)this.paddingByte);
            encodedStr.append((char)this.paddingByte);
        }
        if (len - i == 2) {
            b = (arr[i] & 0xFF) << 8 | arr[i + 1] & 0xFF;
            encodedStr.append(this.encodeTable[b >> 10]);
            encodedStr.append(this.encodeTable[b >> 4 & 0x3F]);
            encodedStr.append(this.encodeTable[b << 2 & 0x3F]);
            encodedStr.append((char)this.paddingByte);
        }
        return encodedStr.toString();
    }

    public String encode(Binary bin) {
        return this.encode(bin.getBytes());
    }

    public Binary decode(String encodedStr) {
        Binary bin = new Binary();
        this.decode(encodedStr, bin);
        return bin;
    }

    private void initDecodeTable() {
        if (this.decodeTable != null) {
            return;
        }
        this.decodeTable = new int[256];
        int i = 0;
        while (i < this.encodeTable.length) {
            this.decodeTable[this.encodeTable[i]] = i;
            ++i;
        }
        this.decodeTable[this.paddingByte] = 0;
    }

    public void decode(String encodedStr, Binary bin) {
        this.initDecodeTable();
        bin.clear();
        String encStr = encodedStr.replaceAll("\\s", "");
        bin.reserve(encStr.length());
        Ex.MUST((encStr.length() & 3) == 0, "\u0414\u043b\u0438\u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0438 Base64 \u043d\u0435 \u043a\u0440\u0430\u0442\u043d\u0430 4");
        int i = 0;
        while (i < encStr.length()) {
            int b4;
            int b3;
            int b2;
            int b1 = this.decodeTable[encStr.charAt(i)];
            Ex.MUST((b1 | (b2 = this.decodeTable[encStr.charAt(i + 1)]) | (b3 = this.decodeTable[encStr.charAt(i + 2)]) | (b4 = this.decodeTable[encStr.charAt(i + 3)])) < 64, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 Base64");
            bin.add(b1 << 2 | b2 >> 4);
            if (encStr.charAt(i + 2) != (char)this.paddingByte) {
                bin.add(b2 << 4 | b3 >> 2);
            }
            if (encStr.charAt(i + 3) != (char)this.paddingByte) {
                bin.add(b3 << 6 | b4);
            }
            i += 4;
        }
    }
}

