/*
 * Decompiled with CFR 0.152.
 */
package org.denom.format;

import java.util.LinkedHashMap;
import java.util.Map;
import org.denom.Arr;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.format.BinBuilder;
import org.denom.format.BinParser;
import org.denom.format.IBinable;

public class TLV
implements IBinable {
    public int tag;
    public Binary value;
    public String description;

    public TLV() {
        this.tag = 0;
        this.value = new Binary();
        this.description = "";
    }

    public TLV(int tag, Binary value) {
        this.tag = tag;
        this.value = value;
    }

    public TLV(int tag, Binary value, String description) {
        this.tag = tag;
        this.value = value;
        this.description = description;
    }

    @Override
    public Binary toBin() {
        BinBuilder bb = new BinBuilder();
        bb.append(this.tag);
        bb.append(this.value);
        return bb.getResult();
    }

    @Override
    public TLV fromBin(Binary bin, int offset) {
        BinParser parser = new BinParser(bin, offset);
        this.tag = parser.getInt();
        this.value = parser.getBinary();
        return this;
    }

    public static Binary TLV4(int tag, Binary value) {
        Binary res = new Binary().reserve(8 + value.size());
        res.addInt(tag);
        res.addInt(value.size());
        res.add(value);
        return res;
    }

    public static Binary TLV4(int tag, Binary ... value) {
        Binary res = new Binary().reserve(50);
        Binary val = Binary.Bin(value);
        res.addInt(tag);
        res.addInt(val.size());
        res.add(val);
        return res;
    }

    public static Arr<TLV> parseTlv4Arr(Binary bin) {
        Arr<TLV> arr = new Arr<TLV>();
        int size = bin.size();
        int offset = 0;
        while (offset < size) {
            Ex.MUST(offset + 4 + 4 <= size, "Incorrect TLV4 List");
            int tag = bin.getIntBE(offset);
            int len = bin.getIntBE(offset += 4);
            Ex.MUST(len >= 0 && (offset += 4) + len <= size, "Incorrect LV4 List");
            arr.add(new TLV(tag, new Binary(bin.getDataRef(), offset, len)));
            offset += len;
        }
        return arr;
    }

    public static Map<Integer, Binary> parseTlv4Map(Binary bin) {
        LinkedHashMap<Integer, Binary> map = new LinkedHashMap<Integer, Binary>();
        int size = bin.size();
        int offset = 0;
        while (offset < size) {
            Ex.MUST(offset + 4 + 4 <= size, "Incorrect TLV4 List");
            int tag = bin.getIntBE(offset);
            int len = bin.getIntBE(offset += 4);
            Ex.MUST(len >= 0 && (offset += 4) + len <= size, "Incorrect TLV4 List");
            map.put(tag, new Binary(bin.getDataRef(), offset, len));
            offset += len;
        }
        return map;
    }
}

