/*
 * Decompiled with CFR 0.152.
 */
package org.denom.log;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.denom.Ex;
import org.denom.Strings;
import org.denom.log.ILog;
import org.denom.log.LogColoredTextPane;
import org.denom.swing.SwingUtils;

public class LogColoredConsoleWindow
implements ILog {
    private JTextField inputTextField;
    private String inputStr;
    private int defaultColor = -1;
    private ILog nextLog;
    private static final int BACKGROUND_COLOR = -15724528;
    public JFrame consoleWindow;
    public LogColoredTextPane coloredTextPaneLog;

    public LogColoredConsoleWindow() {
        this("Console App");
    }

    public LogColoredConsoleWindow(String windowCaption) {
        this(100, 20, 900, 768, windowCaption);
    }

    public LogColoredConsoleWindow(int x, int y, int width, int height, String windowCaption) {
        this.consoleWindow = new JFrame(windowCaption);
        this.consoleWindow.setDefaultCloseOperation(3);
        this.consoleWindow.setLocation(x, y);
        this.consoleWindow.setSize(width, height);
        this.consoleWindow.setResizable(true);
        this.coloredTextPaneLog = new LogColoredTextPane(-15724528, this.defaultColor, false);
        this.consoleWindow.getContentPane().add(new JScrollPane(this.coloredTextPaneLog));
        this.createInputField();
        this.consoleWindow.getContentPane().add((Component)this.inputTextField, "South");
        this.consoleWindow.setVisible(true);
    }

    private void createInputField() {
        this.inputTextField = new JTextField();
        this.inputTextField.setFont(SwingUtils.DEFAULT_FONT);
        this.inputTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LogColoredConsoleWindow.this.inputStr = LogColoredConsoleWindow.this.inputTextField.getText();
                    LogColoredConsoleWindow.this.inputTextField.setText("");
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public String readln() {
        this.inputTextField.grabFocus();
        String temp = this.inputStr;
        while (temp == this.inputStr) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ignored) {
                Ex.THROW("InterruptedException");
            }
        }
        return this.inputStr;
    }

    @Override
    public void write(String text) {
        this.coloredTextPaneLog.write(this.defaultColor, text);
        if (this.nextLog != null) {
            this.nextLog.write(text);
        }
    }

    @Override
    public void write(int color, String text) {
        this.coloredTextPaneLog.write(color, text);
        if (this.nextLog != null) {
            this.nextLog.write(color, text);
        }
    }

    @Override
    public void writeln(String text) {
        this.write(String.valueOf(text) + Strings.ln);
    }

    @Override
    public void writeln(int color, String text) {
        this.write(color, String.valueOf(text) + Strings.ln);
    }

    @Override
    public void setDefaultColor(int color) {
        this.defaultColor = color;
    }

    @Override
    public ILog setNext(ILog log) {
        this.nextLog = log;
        return this;
    }

    @Override
    public void close() {
        this.consoleWindow.setVisible(false);
        this.consoleWindow.dispose();
    }
}

