/*
 * Decompiled with CFR 0.152.
 */
package org.denom.log;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.denom.Ex;
import org.denom.Strings;
import org.denom.log.ILog;
import org.denom.swing.SwingUtils;

public class LogColoredTextPane
extends JTextPane
implements ILog {
    private static final String FONT_NAME = SwingUtils.DEFAULT_FONT.getName();
    private static final int FONT_SIZE = SwingUtils.DEFAULT_FONT.getSize();
    private static final int STRINGS_TO_REPAINT = 100;
    private int maxTextCapacity;
    private int capacityToRemove;
    private ILog nextLog;
    private Color defaultTextColor;
    private Document document;
    private DefaultCaret caret;
    private volatile boolean scrollReady;
    private volatile int counterStrings;
    private boolean isGUIApp;
    private static final long serialVersionUID = 1L;

    public LogColoredTextPane(boolean isGUIApp) {
        this(-16777216, -1, isGUIApp);
    }

    public LogColoredTextPane(int backgroundColor, int defaultTextColor, boolean isGUIApp) {
        this.isGUIApp = isGUIApp;
        this.setDefaultColor(defaultTextColor);
        this.setMaxTextCapacity(1000000);
        this.setBackground(new Color(backgroundColor, true));
        this.setEditable(false);
        this.document = new DefaultStyledDocument();
        this.setDocument(this.document);
        this.caret = new DefaultCaret();
        this.caret.setVisible(false);
        this.caret.setUpdatePolicy(1);
        this.setCaret(this.caret);
        this.startCaretThread();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem itemCopy = new JMenuItem("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
                    itemCopy.addActionListener(new DefaultEditorKit.CopyAction());
                    itemCopy.setEnabled(LogColoredTextPane.this.getSelectionStart() != LogColoredTextPane.this.getSelectionEnd());
                    menu.add(itemCopy);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void setMaxTextCapacity(int textCapacity) {
        Ex.MUST(textCapacity > 0, "Text capacity must be > 0");
        this.maxTextCapacity = textCapacity;
        this.capacityToRemove = textCapacity / 8 + 1;
    }

    public void startCaretThread() {
        final Runnable scrollRunnable = new Runnable(){

            @Override
            public void run() {
                LogColoredTextPane.this.caret.setDot(LogColoredTextPane.this.maxTextCapacity);
            }
        };
        Thread caretThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ignored) {
                        Ex.THROW("InterruptedException");
                    }
                    if (!LogColoredTextPane.this.scrollReady) continue;
                    SwingUtilities.invokeLater(scrollRunnable);
                    LogColoredTextPane.this.scrollReady = false;
                }
            }
        });
        caretThread.setName("LogColoredTextPane Scroll");
        caretThread.setDaemon(true);
        caretThread.start();
    }

    private void writeDocument(final Color color, final String text) {
        Runnable writeStrRunnable = new Runnable(){

            @Override
            public void run() {
                LogColoredTextPane logColoredTextPane = LogColoredTextPane.this;
                logColoredTextPane.counterStrings = logColoredTextPane.counterStrings + 1;
                try {
                    if (LogColoredTextPane.this.document.getLength() > LogColoredTextPane.this.maxTextCapacity) {
                        LogColoredTextPane.this.document.remove(0, LogColoredTextPane.this.capacityToRemove);
                    }
                    SimpleAttributeSet attr = new SimpleAttributeSet();
                    StyleConstants.setFontFamily(attr, FONT_NAME);
                    StyleConstants.setFontSize(attr, FONT_SIZE);
                    StyleConstants.setForeground(attr, color);
                    LogColoredTextPane.this.document.insertString(LogColoredTextPane.this.document.getLength(), text, attr);
                    LogColoredTextPane.this.scrollReady = true;
                }
                catch (BadLocationException e) {
                    Ex.THROW(e);
                }
            }
        };
        if (this.isGUIApp) {
            SwingUtilities.invokeLater(writeStrRunnable);
            return;
        }
        if (this.counterStrings < 100) {
            SwingUtilities.invokeLater(writeStrRunnable);
        } else {
            try {
                SwingUtilities.invokeAndWait(writeStrRunnable);
                this.counterStrings = 0;
            }
            catch (Throwable e) {
                Ex.THROW(e);
            }
        }
    }

    @Override
    public void write(String text) {
        this.writeDocument(this.defaultTextColor, text);
        if (this.nextLog != null) {
            this.nextLog.write(text);
        }
    }

    @Override
    public void write(int color, String text) {
        this.writeDocument(new Color(color, true), text);
        if (this.nextLog != null) {
            this.nextLog.write(color, text);
        }
    }

    @Override
    public void writeln(String text) {
        this.write(String.valueOf(text) + Strings.ln);
    }

    @Override
    public void writeln(int color, String text) {
        this.write(color, String.valueOf(text) + Strings.ln);
    }

    @Override
    public void setDefaultColor(int color) {
        this.defaultTextColor = new Color(color, true);
    }

    @Override
    public ILog setNext(ILog log) {
        this.nextLog = log;
        return this;
    }

    @Override
    public void close() {
    }
}

