/*
 * Decompiled with CFR 0.152.
 */
package org.denom.log;

import org.denom.Strings;
import org.denom.log.ILog;

public class LogConsoleANSI
implements ILog {
    private ILog mNextLog;
    public static final String COLOR_RESET = "\u001b[0m";

    public static String toEscColor(int color) {
        switch (color) {
            case -16777216: {
                return "\u001b[30m";
            }
            case -8454144: {
                return "\u001b[31m";
            }
            case -16732416: {
                return "\u001b[32m";
            }
            case -999424: {
                return "\u001b[33m";
            }
            case -16777089: {
                return "\u001b[34m";
            }
            case -4194112: {
                return "\u001b[35m";
            }
            case -16744577: {
                return "\u001b[36m";
            }
            case -6246208: {
                return "\u001b[37m";
            }
            case -7303024: {
                return "\u001b[90m";
            }
            case -65536: {
                return "\u001b[91m";
            }
            case -16711936: {
                return "\u001b[92m";
            }
            case -3968: {
                return "\u001b[93m";
            }
            case -16776961: {
                return "\u001b[94m";
            }
            case -1040144: {
                return "\u001b[95m";
            }
            case -8326928: {
                return "\u001b[96m";
            }
            case -1: {
                return "\u001b[97m";
            }
        }
        return "";
    }

    @Override
    public void write(String text) {
        System.out.print(text);
        if (this.mNextLog != null) {
            this.mNextLog.write(text);
        }
    }

    @Override
    public void write(int color, String text) {
        System.out.print(LogConsoleANSI.toEscColor(color));
        System.out.print(text);
        System.out.print(COLOR_RESET);
        if (this.mNextLog != null) {
            this.mNextLog.write(color, text);
        }
    }

    @Override
    public void writeln(String text) {
        this.write(String.valueOf(text) + Strings.ln);
    }

    @Override
    public void writeln(int color, String text) {
        this.write(color, String.valueOf(text) + Strings.ln);
    }

    @Override
    public void setDefaultColor(int color) {
    }

    @Override
    public ILog setNext(ILog log) {
        this.mNextLog = log;
        return this;
    }

    @Override
    public void close() {
    }
}

