/*
 * Decompiled with CFR 0.152.
 */
package org.denom.log;

import org.denom.Ex;
import org.denom.Strings;
import org.denom.log.ILog;

public class LogTime
implements ILog {
    private ILog mLog;
    private ILog mNextLog;

    public LogTime(ILog log) {
        Ex.MUST(log != null, "\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 log \u0434\u043e\u043b\u0436\u0435\u043d != null");
        this.mLog = log;
    }

    private String appendCurTime(String message) {
        return String.valueOf(Strings.currentDateTime()) + " -- " + message;
    }

    @Override
    public void write(String message) {
        if (!message.isEmpty() && !message.equals(Strings.ln)) {
            message = this.appendCurTime(message);
        }
        this.mLog.write(message);
        if (this.mNextLog != null) {
            this.mNextLog.write(message);
        }
    }

    @Override
    public void write(int color, String message) {
        if (!message.isEmpty() && !message.equals(Strings.ln)) {
            message = this.appendCurTime(message);
        }
        this.mLog.write(color, message);
        if (this.mNextLog != null) {
            this.mNextLog.write(color, message);
        }
    }

    @Override
    public void writeln(String message) {
        this.write(String.valueOf(message) + Strings.ln);
    }

    @Override
    public void writeln(int color, String message) {
        this.write(color, String.valueOf(message) + Strings.ln);
    }

    @Override
    public void setDefaultColor(int color) {
    }

    @Override
    public ILog setNext(ILog log) {
        this.mNextLog = log;
        return this;
    }

    @Override
    public void close() {
        this.mLog.close();
    }
}

