/*
 * Decompiled with CFR 0.152.
 */
package org.denom.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.denom.Ex;
import org.denom.net.TCPServer;

public abstract class TCPServerSession {
    protected final SocketChannel socket;
    protected final TCPServer tcpServer;
    protected SelectionKey selectionKey = null;
    public InetSocketAddress remoteAddress;
    protected volatile ConcurrentLinkedQueue<ByteBuffer> writeQueue = new ConcurrentLinkedQueue();

    protected TCPServerSession() {
        this.socket = null;
        this.tcpServer = null;
    }

    public abstract TCPServerSession newInstance(TCPServer var1, SocketChannel var2);

    protected TCPServerSession(TCPServer tcpServer, SocketChannel clientSocket) {
        this.socket = clientSocket;
        this.tcpServer = tcpServer;
        try {
            this.remoteAddress = (InetSocketAddress)clientSocket.getRemoteAddress();
        }
        catch (IOException ex) {
            Ex.THROW(ex.toString());
        }
    }

    public SocketChannel getSocket() {
        return this.socket;
    }

    public void close() {
        this.writeQueue.clear();
        try {
            this.selectionKey.cancel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected abstract void readFromSocket();

    public void writeToSocket(ByteBuffer buf) {
        this.writeQueue.offer(buf);
        this.tcpServer.needToFlush(this);
    }

    protected void onWritten(ByteBuffer buf) {
    }
}

