/*
 * Decompiled with CFR 0.152.
 */
package org.denom.net.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Pair;
import org.denom.log.ILog;
import org.denom.log.LogDummy;
import org.denom.net.http.HttpRequest;
import org.denom.net.http.HttpResponse;

public class HttpClient {
    private ILog log = new LogDummy();
    private int connectTimeoutMs = 15000;
    private int readTimeoutMs = 15000;
    private SSLSocketFactory sslSocketFactory;
    private int redirectDepth;
    private final byte[] buf = new byte[1024];

    public HttpClient setLog(ILog log) {
        if (log != null) {
            this.log = log;
        }
        return this;
    }

    public HttpClient setConnectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
        return this;
    }

    public HttpClient setReadTimeoutMs(int readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
        return this;
    }

    public HttpClient setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public HttpResponse transmit(HttpRequest request) {
        return this.transmit(request.url, request.method, request.headers, request.body);
    }

    public HttpResponse transmit(String url, String method, List<Pair<String, String>> headers, byte[] body) {
        Ex.MUST(url != null && !url.isEmpty(), "URL not set!");
        Ex.MUST(method != null && !method.isEmpty(), "Method not set!");
        try {
            HttpURLConnection connection;
            block29: {
                connection = (HttpURLConnection)new URI(url).toURL().openConnection(Proxy.NO_PROXY);
                if (this.sslSocketFactory != null && connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
                }
                connection.setConnectTimeout(this.connectTimeoutMs);
                connection.setReadTimeout(this.readTimeoutMs);
                connection.setUseCaches(false);
                connection.setAllowUserInteraction(false);
                connection.setRequestMethod(method);
                this.log.writeln("HTTP " + connection.getRequestMethod() + " " + connection.getURL());
                if (headers != null) {
                    this.log.writeln("  request headers:");
                    for (Pair<String, String> header : headers) {
                        connection.setRequestProperty((String)header.key, (String)header.value);
                        this.log.writeln("    " + (String)header.key + ": " + (String)header.value);
                    }
                }
                if (body != null && body.length > 0) {
                    connection.setDoOutput(true);
                    this.log.writeln("  request len: " + body.length);
                    ByteArrayInputStream requestStream = new ByteArrayInputStream(body);
                    Object object = null;
                    Object var8_11 = null;
                    try (OutputStream connectionStream = connection.getOutputStream();){
                        this.copyStream(requestStream, connectionStream);
                        break block29;
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                connection.setDoOutput(false);
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 301: 
                case 302: {
                    Ex.MUST(this.redirectDepth < 5, "Too many redirects!");
                    ++this.redirectDepth;
                    String redirectUrl = connection.getHeaderField("Location");
                    if (redirectUrl.startsWith("https")) {
                        this.log.writeln("  redirect http -> https");
                    }
                    return this.transmit(redirectUrl, method, headers, body);
                }
            }
            this.redirectDepth = 0;
            String responseMessage = connection.getResponseMessage();
            this.log.writeln("  status: " + responseCode);
            boolean statusOk = responseCode < 400;
            ByteArrayOutputStream respStream = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object var11_17 = null;
            try (InputStream connectionStream = statusOk ? connection.getInputStream() : connection.getErrorStream();){
                if (connectionStream != null) {
                    this.copyStream(connectionStream, respStream);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            byte[] responseData = respStream.toByteArray();
            this.log.writeln("  response len: " + responseData.length);
            return new HttpResponse(responseCode, responseMessage, connection.getHeaderFields(), responseData);
        }
        catch (Throwable ex) {
            Ex.THROW(ex);
            return null;
        }
    }

    private void copyStream(InputStream from, OutputStream to) throws IOException {
        int read;
        while ((read = from.read(this.buf)) != -1) {
            to.write(this.buf, 0, read);
        }
        to.flush();
    }

    public static SSLSocketFactory trustAllCerts() {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }
            }}, new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (GeneralSecurityException ex) {
            Ex.THROW(ex);
            return null;
        }
    }

    public static SSLSocketFactory trustUserCA(KeyStore trustStore) {
        Ex.MUST(trustStore != null, "Trust KeyStore not set!");
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            TrustManager[] trustManagers = tmf.getTrustManagers();
            sslContext.init(null, trustManagers, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException ex) {
            Ex.THROW(ex);
            return null;
        }
    }

    public static SSLSocketFactory trustUserCaAndKeys(KeyStore trustStore, KeyStore keyStore, String keyPassword) {
        Ex.MUST(trustStore != null, "Trust KeyStore not set!");
        Ex.MUST(keyStore != null, "Key KeyStore not set!");
        Ex.MUST(keyPassword != null, "Key Password not set!");
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmFactory.init(trustStore);
            TrustManager[] trustManagers = tmFactory.getTrustManagers();
            KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmFactory.init(keyStore, keyPassword.toCharArray());
            KeyManager[] keyManagers = kmFactory.getKeyManagers();
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException ex) {
            Ex.THROW(ex);
            return null;
        }
    }

    public static KeyStore createKeyStore(Binary keyStoreBin, String keyStoreFormat, String keyStorePassword) {
        KeyStore keystore = null;
        try {
            keystore = KeyStore.getInstance(keyStoreFormat);
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayInputStream readStream = new ByteArrayInputStream(keyStoreBin.getBytes());){
                keystore.load(readStream, keyStorePassword.toCharArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            Ex.THROW(ex);
        }
        return keystore;
    }
}

