/*
 * Decompiled with CFR 0.152.
 */
package org.denom.net.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.denom.Ex;
import org.denom.Pair;
import org.denom.Strings;
import org.denom.format.JSONObject;

public class HttpRequest {
    public final String url;
    public final String method;
    public final List<Pair<String, String>> headers;
    public byte[] body;

    public HttpRequest(String url, String method) {
        this.url = url;
        this.method = method;
        this.headers = new ArrayList<Pair<String, String>>();
    }

    public HttpRequest addHeader(String key, String value) {
        this.headers.add(Pair.of(key, value));
        return this;
    }

    public HttpRequest addHeader(String header) {
        int splitIndex = header.indexOf(58);
        Ex.MUST(splitIndex != -1, "Wrong header");
        this.headers.add(Pair.of(header.substring(0, splitIndex), header.substring(splitIndex + 1).trim()));
        return this;
    }

    public HttpRequest setBody(byte[] requestData) {
        this.body = requestData;
        return this;
    }

    public HttpRequest setBody(String requestStr) {
        return this.setBody(requestStr, Strings.UTF8);
    }

    public HttpRequest setBody(String requestStr, Charset charset) {
        return this.setBody(requestStr.getBytes(charset));
    }

    public HttpRequest setBody(JSONObject requestJson) {
        return this.setBody(requestJson.toString());
    }

    public static String formQueryUrl(String url, String[] ... queryParams) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(url);
            int i = 0;
            while (i < queryParams.length) {
                String[] param = queryParams[i];
                Ex.MUST(param.length == 2, "Wrong url params");
                sb.append(i == 0 ? (char)'?' : '&');
                sb.append(URLEncoder.encode(param[0], "utf-8"));
                sb.append('=');
                sb.append(URLEncoder.encode(param[1], "utf-8"));
                ++i;
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException ex) {
            Ex.THROW(ex);
            return null;
        }
    }
}

