/*
 * Decompiled with CFR 0.152.
 */
package org.denom.net.http;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.denom.Ex;
import org.denom.format.JSONObject;

public class HttpResponse {
    public final int code;
    public final String message;
    public final Map<String, List<String>> headers;
    public final byte[] body;

    public HttpResponse(int responseCode, String responseMessage, Map<String, List<String>> headers, byte[] body) {
        this.code = responseCode;
        this.message = responseMessage;
        this.headers = headers;
        this.body = body;
    }

    public HttpResponse checkStatus() {
        Ex.MUST(this.code >= 100, "Wrong status code: " + this.code);
        if (this.code >= 400) {
            StringBuilder sb = new StringBuilder();
            sb.append("HTTP Error ");
            sb.append(this.code);
            sb.append(' ');
            if (this.message != null) {
                sb.append(this.message);
            }
            sb.append('\n');
            if (this.body != null) {
                sb.append(this.asString());
            }
            Ex.THROW(this.code, sb.toString());
        }
        return this;
    }

    public Charset getCharset() {
        List<String> contentTypeVals = this.headers.get("Content-Type");
        if (contentTypeVals == null) {
            return null;
        }
        for (String contentTypeVal : contentTypeVals) {
            int charsetStart = contentTypeVal.indexOf("charset=");
            if (charsetStart == -1) continue;
            String charsetName = contentTypeVal.substring(charsetStart + 8).trim();
            return Charset.forName(charsetName);
        }
        return null;
    }

    public String asString() {
        Charset respCharset = this.getCharset();
        if (respCharset == null) {
            respCharset = Charset.forName("UTF-8");
        }
        return this.asString(respCharset);
    }

    public String asString(Charset charset) {
        return new String(this.body, charset);
    }

    public JSONObject asJSON() {
        return new JSONObject(this.asString());
    }
}

