/*
 * Decompiled with CFR 0.152.
 */
package org.denom.net.http;

import javax.net.ssl.SSLSocketFactory;
import org.denom.Ex;
import org.denom.format.JSONObject;
import org.denom.log.ILog;
import org.denom.net.http.HttpClient;
import org.denom.net.http.HttpRequest;
import org.denom.net.http.HttpResponse;

public class RestClient {
    private final String baseUrl;
    private final HttpClient httpClient;

    public RestClient(String baseUrl) {
        this(baseUrl, null);
    }

    public RestClient(String baseUrl, SSLSocketFactory sslSocketFactory) {
        this.baseUrl = baseUrl;
        this.httpClient = new HttpClient().setSslSocketFactory(sslSocketFactory);
    }

    public RestClient setLog(ILog log) {
        this.httpClient.setLog(log);
        return this;
    }

    public RestClient setReadTimeoutMs(int readTimeoutMs) {
        this.httpClient.setReadTimeoutMs(readTimeoutMs);
        return this;
    }

    public JSONObject post(String requestPath, JSONObject requestData) {
        HttpRequest request = new HttpRequest(String.valueOf(this.baseUrl) + '/' + requestPath, "POST");
        request.setBody(requestData);
        request.addHeader("Content-Type", "application/json; charset=utf-8");
        request.addHeader("Content-Length", String.valueOf(request.body.length));
        HttpResponse response = this.httpClient.transmit(request);
        response.checkStatus();
        JSONObject respJSON = response.asJSON();
        return respJSON;
    }

    public JSONObject get(String requestPath, String[] ... queryParams) {
        String queryURL = HttpRequest.formQueryUrl(String.valueOf(this.baseUrl) + '/' + requestPath, queryParams);
        HttpRequest request = new HttpRequest(queryURL, "GET");
        request.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        HttpResponse response = this.httpClient.transmit(request);
        response.checkStatus();
        JSONObject respJSON = response.asJSON();
        return respJSON;
    }

    public JSONObject call(String path, JSONObject requestData) {
        JSONObject response = this.post(path, requestData);
        int errorCode = response.optInt("Error Code", 0);
        if (errorCode != 0) {
            Ex.THROW(errorCode, response.optString("Error Message", "No description"));
        }
        return response;
    }
}

