/*
 * Decompiled with CFR 0.152.
 */
package org.denom.net.http;

import java.net.URI;
import java.net.URL;
import javax.net.ssl.SSLSocketFactory;
import org.denom.Ex;
import org.denom.net.http.HttpClient;
import org.denom.net.http.HttpRequest;
import org.denom.net.http.HttpResponse;

public class SOAPClient {
    private static final String RETURN_TAG = "<return>";
    private static final String RETURN_CTAG = "</return>";
    private static final String FAULT_TAG = "<S:Fault";
    private static final String FAULT_STRING_TAG = "<faultstring>";
    private static final String FAULT_STRING_CTAG = "</faultstring>";
    private static final String M_RETURN_TAG_START = "<m:return";
    private static final String M_RETURN_CTAG = "</m:return>";
    private HttpClient httpClient;
    private URL serviceURL;
    private String serviceNamespace;

    public SOAPClient(String serviceURL, String serviceNamespace) {
        this(serviceURL, serviceNamespace, null);
    }

    public SOAPClient(String serviceURL, String serviceNamespace, SSLSocketFactory sslSocketFactory) {
        this.serviceNamespace = serviceNamespace;
        try {
            this.serviceURL = new URI(serviceURL).toURL();
        }
        catch (Throwable ex) {
            Ex.THROW(ex.toString());
        }
        this.httpClient = new HttpClient().setSslSocketFactory(sslSocketFactory);
    }

    public String callMethod(String methodName, String[][] parameters) {
        return this.callMethod(methodName, "", parameters);
    }

    public String callMethod(String methodName, String soapAction, String[][] parameters) {
        HttpRequest httpRequest = new HttpRequest(this.serviceURL.toString(), "POST");
        httpRequest.addHeader("Accept", "text/xml");
        httpRequest.addHeader("Content-Type", "text/xml;charset=utf-8");
        httpRequest.addHeader("Connection", "keep-alive");
        httpRequest.addHeader("SOAPAction", "\"" + soapAction + "\"");
        httpRequest.setBody(this.formatSoapRequest(methodName, this.formParamsString(parameters)));
        HttpResponse httpResponse = this.httpClient.transmit(httpRequest);
        httpResponse.checkStatus();
        return this.getReturnValue(httpResponse.asString());
    }

    private String formatSoapRequest(String methodName, String parameters) {
        StringBuilder str = new StringBuilder(200 + parameters.length());
        str.append("<?xml version=\"1.0\" ?><S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\"><S:Body><ns2:");
        str.append(methodName);
        str.append(" xmlns:ns2=\"");
        str.append(this.serviceNamespace);
        str.append("\">");
        str.append(parameters);
        str.append("</ns2:");
        str.append(methodName);
        str.append("></S:Body></S:Envelope>");
        return str.toString();
    }

    private String formParamsString(String[][] parameters) {
        StringBuilder str = new StringBuilder(parameters.length * 50);
        String[][] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String[] entry = stringArray[n2];
            Ex.MUST(entry.length == 2);
            str.append("<");
            str.append(entry[0]);
            str.append(">");
            str.append(entry[1]);
            str.append("</");
            str.append(entry[0]);
            str.append(">");
            ++n2;
        }
        return str.toString();
    }

    private String getReturnValue(String response) {
        int fault_begin = response.indexOf(FAULT_TAG);
        if (fault_begin != -1) {
            int ex_begin = response.indexOf(FAULT_STRING_TAG);
            int ex_end = response.indexOf(FAULT_STRING_CTAG);
            Ex.THROW("Server send error: " + response.substring(ex_begin + FAULT_STRING_TAG.length(), ex_end));
        }
        int begin = response.indexOf(RETURN_TAG);
        int end = response.indexOf(RETURN_CTAG);
        if (begin == -1 || end == -1) {
            int beginM = response.indexOf(M_RETURN_TAG_START);
            int endM = response.indexOf(M_RETURN_CTAG);
            if (beginM == -1 || endM == -1) {
                return "";
            }
            int beginM_End = response.indexOf(62, beginM + 1);
            return response.substring(beginM_End + 1, endM);
        }
        return response.substring(begin + RETURN_TAG.length(), end);
    }
}

