/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.denom.Arr;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.scp81.TlsConst;

public class TlsHelloClient {
    public int protocol;
    public Binary random;
    public Binary sessionID;
    public Arr<Integer> cipherSuites;
    public Map<Integer, Binary> extensions;

    public TlsHelloClient(int protocol, Binary random, Binary sessionID, Arr<Integer> cipherSuites, Map<Integer, Binary> extensions) {
        Ex.MUST(random != null && sessionID != null && cipherSuites != null && extensions != null, "Wrong ClientHello params");
        Ex.MUST(protocol >= 769 && protocol <= 771, 47);
        this.protocol = protocol;
        this.random = random;
        this.sessionID = sessionID;
        this.cipherSuites = cipherSuites;
        this.extensions = extensions;
    }

    public TlsHelloClient(Binary message) {
        this.protocol = message.getU16(0);
        this.random = message.slice(2, 32);
        int offset = 34;
        int len = message.get(offset);
        this.sessionID = message.slice(++offset, len);
        offset += len;
        len = message.getU16(offset);
        Ex.MUST(len >= 2 && (len & 1) == 0 && (offset += 2) + len <= message.size());
        int end = offset + len;
        this.cipherSuites = new Arr();
        while (offset < end) {
            this.cipherSuites.add(message.getU16(offset));
            offset += 2;
        }
        Ex.MUST(message.getU16(offset) == 256);
        this.extensions = TlsHelloClient.parseExtensions(message, offset += 2);
    }

    public Binary toBin() {
        Binary b = new Binary().reserve(64);
        b.addU16(this.protocol);
        b.add(this.random);
        b.add(this.sessionID.size());
        b.add(this.sessionID);
        b.addU16(this.cipherSuites.size() * 2);
        Iterator iterator = this.cipherSuites.iterator();
        while (iterator.hasNext()) {
            int suite = (Integer)iterator.next();
            b.addU16(suite);
        }
        b.add(1);
        b.add(0);
        TlsHelloClient.addExtensions(b, this.extensions);
        return b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("          CLIENT HELLO:\n");
        sb.append(String.format("               version:  %04X (%s)\n", this.protocol, TlsConst.Protocol.toStr(this.protocol)));
        sb.append("                random:  " + this.random.Hex() + "\n");
        sb.append("             sessionId:  " + this.sessionID.Hex() + "\n");
        sb.append("          cipherSuites:\n");
        Iterator<Object> iterator = this.cipherSuites.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            sb.append(String.format("                         %04X (%s)\n", n, TlsConst.CipherSuite.toStr(n)));
        }
        sb.append("            extensions:\n");
        for (Map.Entry entry : this.extensions.entrySet()) {
            sb.append(String.format("                         type:  %04X (%s),  data:  %s\n", entry.getKey(), TlsConst.Extension.toStr((Integer)entry.getKey()), ((Binary)entry.getValue()).Hex()));
        }
        return sb.toString();
    }

    static void addExtensions(Binary buf, Map<Integer, Binary> extensions) {
        if (extensions.isEmpty()) {
            return;
        }
        int lenOffset = buf.size();
        buf.addU16(0);
        for (Map.Entry<Integer, Binary> entry : extensions.entrySet()) {
            buf.addU16(entry.getKey());
            buf.addU16(entry.getValue().size());
            buf.add(entry.getValue());
        }
        buf.setU16(lenOffset, buf.size() - lenOffset - 2);
    }

    static Map<Integer, Binary> parseExtensions(Binary buf, int offset) {
        HashMap<Integer, Binary> extensions = new HashMap<Integer, Binary>();
        if (offset >= buf.size()) {
            return extensions;
        }
        int len = buf.getU16(offset);
        offset += 2;
        while (offset < buf.size()) {
            int extType = buf.getU16(offset);
            len = buf.getU16(offset += 2);
            Binary extData = buf.slice(offset += 2, len);
            Ex.MUST(extensions.put(extType, extData) == null, 47, "Duplicate extension");
            offset += len;
        }
        return extensions;
    }
}

