/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.format.LV;
import org.denom.scp81.TlsHelloClient;
import org.denom.scp81.TlsHelloServer;
import org.denom.scp81.TlsPSKSession;

public class TlsPSKClientSession
extends TlsPSKSession {
    public TlsPSKClientSession(int protocolVersion, Binary identity, Binary psk) {
        super(false);
        this.protocolVersion = protocolVersion;
        this.identity = identity.clone();
        this.psk = psk.clone();
    }

    public void startHandshake() {
        Ex.MUST(this.funcSendData != null && this.funcRecievedAppData != null, "Wrong constructed TlsPSKClientSession");
        Ex.MUST(!this.handshakeDone, "Handshake done already");
        TlsHelloClient hello = new TlsHelloClient(this.protocolVersion, Binary.Bin().randomSecure(32), Binary.Bin(), this.cipherSuites, this.extensions);
        this.gotClientHello(hello);
        this.log.write(this.colorSend3, hello.toString());
        this.sendHandshakeMsg(1, hello.toBin());
        this.state = 1;
    }

    @Override
    protected void onHandshakeMessage(int type, Binary message, Binary data) {
        switch (type) {
            case 2: {
                this.onServerHello(message, data);
                break;
            }
            case 12: {
                this.onServerKeyExchange(message, data);
                break;
            }
            case 14: {
                this.onServerHelloDone(message, data);
                break;
            }
            case 20: {
                this.onServerFinished(data);
                break;
            }
            default: {
                throw new Ex(10);
            }
        }
    }

    protected void onServerHello(Binary message, Binary data) {
        Ex.MUST(this.state == 1, 10);
        this.addHandshakeMessage(message);
        TlsHelloServer serverHello = new TlsHelloServer(data);
        this.log.write(this.colorRecv3, serverHello.toString());
        Ex.MUST(serverHello.protocol == this.protocolVersion, 70);
        Ex.MUST(this.cipherSuites.contains(serverHello.cipherSuite), 47);
        serverHello.extensions.forEach((extension, extData) -> Ex.MUST(extData.equals((Binary)this.extensions.get(extension)), 47));
        this.gotServerHello(serverHello);
        this.state = 2;
    }

    protected void onServerKeyExchange(Binary message, Binary data) {
        Ex.MUST(this.state == 2, 10);
        this.addHandshakeMessage(message);
        int hintLen = data.getU16(0);
        Ex.MUST(data.size() == 2 + hintLen, 50);
        Binary pskIdentityHint = data.slice(2, hintLen);
        String str = "";
        try {
            str = pskIdentityHint.asUTF8();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.log.writeln(this.colorRecv3, "         IDENTITY HINT:  " + pskIdentityHint.Hex() + ",    as String:  " + str);
        this.state = 3;
    }

    protected void onServerHelloDone(Binary message, Binary data) {
        Ex.MUST(this.state == 2 || this.state == 3, 10);
        Ex.MUST(data.size() == 0, 50);
        this.addHandshakeMessage(message);
        this.sendHandshakeMsg(16, LV.LV2(this.identity));
        this.finishHandshake();
        this.state = 10;
    }

    protected void onServerFinished(Binary data) {
        Ex.MUST(this.state == 11, 10);
        Ex.MUST(data.size() == 12, 50);
        Ex.MUST(this.calcVerifyData(!this.isServer).equals(data), 51);
        this.state = 20;
        this.handshakeMessages = null;
        this.handshakeDone = true;
    }
}

