/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.AES;
import org.denom.crypt.blockcipher.AlignMode;
import org.denom.crypt.blockcipher.BlockCipher;
import org.denom.crypt.blockcipher.CryptoMode;
import org.denom.crypt.blockcipher.TripleDES;
import org.denom.crypt.hash.HMAC;
import org.denom.crypt.hash.MD5;
import org.denom.crypt.hash.SHA1;
import org.denom.crypt.hash.SHA256;
import org.denom.scp81.TlsPSKSession;

public class TlsPSKCrypt {
    protected static final int COLOR_CRYPT = -16736208;
    protected BlockCipher cipher = null;
    protected int blockSize = 0;
    protected boolean useExplicitIV = false;
    protected Binary iv = Binary.Bin();
    protected long seqNo = 0L;
    protected HMAC hmac;
    protected int hmacSize;
    private Binary masterSecret;
    protected TlsPSKSession session;

    private TlsPSKCrypt(TlsPSKSession session, boolean isServerKeys) {
        Binary hmacKey;
        this.session = session;
        session.cryptLimit = session.plainLimit;
        this.masterSecret = this.calcMasterSecret(session.psk);
        session.log.writeln(-16736208, "    Master Secret:  " + this.masterSecret.Hex());
        int suite = session.cipherSuite;
        int cipherKeySize = 0;
        if (suite == 174 || suite == 140) {
            cipherKeySize = 16;
            this.cipher = new AES();
            this.blockSize = this.cipher.getBlockSize();
        }
        if (suite == 139) {
            cipherKeySize = 24;
            this.cipher = new TripleDES();
            this.blockSize = this.cipher.getBlockSize();
        }
        this.useExplicitIV = session.protocolVersion > 769;
        this.hmac = suite == 174 || suite == 176 ? new HMAC(new SHA256()) : new HMAC(new SHA1());
        this.hmacSize = session.isTruncateHMac ? Math.min(this.hmac.getSize(), 10) : this.hmac.getSize();
        session.cryptLimit += this.hmacSize;
        session.log.writeln(-16736208, "       HMAC size :  " + this.hmacSize);
        int keyBlockSize = this.hmac.getSize() * 2 + cipherKeySize * 2;
        if (!this.useExplicitIV && this.cipher != null) {
            keyBlockSize += this.blockSize * 2;
        }
        Binary keyBlock = this.calcKeyBlock(keyBlockSize);
        session.log.writeln(-16736208, "       Key Block :  " + keyBlock.Hex());
        int offset = 0;
        if (isServerKeys) {
            hmacKey = keyBlock.slice(offset + this.hmac.getSize(), this.hmac.getSize());
            session.log.writeln(-16736208, " Server HMAC Key :  " + hmacKey.Hex());
        } else {
            hmacKey = keyBlock.slice(offset, this.hmac.getSize());
            session.log.writeln(-16736208, " Client HMAC Key :  " + hmacKey.Hex());
        }
        this.hmac.setKey(hmacKey);
        offset += this.hmac.getSize() * 2;
        if (this.cipher != null) {
            session.cryptLimit += 256;
            this.cipher.setKey(keyBlock.slice(isServerKeys ? offset + cipherKeySize : offset, cipherKeySize));
            offset += cipherKeySize * 2;
            session.log.writeln(-16736208, "      expicit IV :  " + this.useExplicitIV);
            if (this.useExplicitIV) {
                this.iv.assign(Binary.Bin(this.blockSize));
                session.cryptLimit += this.blockSize;
            } else {
                this.iv.assign(keyBlock, isServerKeys ? offset + this.blockSize : offset, this.blockSize);
                offset += this.blockSize * 2;
            }
            session.log.writeln(-16736208, "              IV :  " + this.iv.Hex());
        }
    }

    public static TlsPSKCrypt createEncoder(TlsPSKSession session, boolean isServerKeys) {
        session.log.writeln(-16736208, "    ENCODER : ");
        TlsPSKCrypt inst = new TlsPSKCrypt(session, isServerKeys);
        if (inst.cipher != null) {
            inst.cipher.startEncrypt(CryptoMode.CBC, AlignMode.NONE, inst.iv);
        }
        return inst;
    }

    public static TlsPSKCrypt createDecoder(TlsPSKSession session, boolean isServerKeys) {
        session.log.writeln(-16736208, "    DECODER : ");
        TlsPSKCrypt inst = new TlsPSKCrypt(session, isServerKeys);
        if (inst.cipher != null) {
            inst.cipher.startDecrypt(CryptoMode.CBC, AlignMode.NONE, inst.iv);
        }
        return inst;
    }

    private Binary calcMasterSecret(Binary psk) {
        Binary preMasterSecret = new Binary();
        preMasterSecret.addU16(psk.size());
        preMasterSecret.add(new Binary(psk.size(), 0));
        preMasterSecret.addU16(psk.size());
        preMasterSecret.add(psk);
        return this.PRF(preMasterSecret, "master secret", Binary.Bin(this.session.clientRandom).add(this.session.serverRandom), 48);
    }

    private Binary calcKeyBlock(int length) {
        return this.PRF(this.masterSecret, "key expansion", Binary.Bin(this.session.serverRandom).add(this.session.clientRandom), length);
    }

    public Binary calcVerifyData(boolean isFromServer) {
        String asciiLabel = isFromServer ? "server finished" : "client finished";
        Binary hash = this.session.protocolVersion == 771 ? new SHA256().calc(this.session.handshakeMessages) : Binary.Bin(new MD5().calc(this.session.handshakeMessages), new SHA1().calc(this.session.handshakeMessages));
        this.session.log.writeln(-16736208, "  Handshake Hash :  " + hash.Hex());
        return this.PRF(this.masterSecret, asciiLabel, hash, 12);
    }

    private Binary pad(Binary data) {
        int padLen = this.blockSize - data.size() % this.blockSize;
        int padByte = padLen - 1;
        data.add(Binary.Bin(padLen, padByte));
        return data;
    }

    public Binary calcHMac(int recordType, Binary msg) {
        Binary b = new Binary().reserve(msg.size() + 13);
        b.addLong(this.seqNo++);
        b.add(recordType);
        b.addU16(this.session.protocolVersion);
        b.addU16(msg.size());
        b.add(msg);
        return this.hmac.calc(b).first(this.hmacSize);
    }

    public Binary encode(int contentType, Binary plain) {
        Binary buf = Binary.Bin().reserve(plain.size() + this.blockSize + this.hmacSize);
        if (this.cipher != null && this.useExplicitIV) {
            buf.add(Binary.Bin().randomSecure(this.blockSize));
        }
        buf.add(plain);
        if (this.session.isEncryptThenMAC) {
            buf = this.cipher.process(this.pad(buf));
            buf.add(this.calcHMac(contentType, buf));
        } else {
            buf.add(this.calcHMac(contentType, plain));
            if (this.cipher != null) {
                buf = this.cipher.process(this.pad(buf));
            }
        }
        return buf;
    }

    public Binary decode(int recordType, Binary crypt) {
        if (this.session.isEncryptThenMAC) {
            int minLen = this.blockSize + this.hmacSize + (this.useExplicitIV ? this.blockSize : 0);
            Ex.MUST(crypt.size() >= minLen, 50);
            Binary encrypted = crypt.first(crypt.size() - this.hmacSize);
            Binary expectedMac = this.calcHMac(recordType, encrypted);
            Ex.MUST(crypt.last(this.hmacSize).equals(expectedMac), 20);
            Ex.MUST(encrypted.size() % this.blockSize == 0, 20);
            encrypted = this.cipher.process(encrypted);
            int padLen = this.checkPadding(encrypted, 0);
            int ivLen = this.useExplicitIV ? this.blockSize : 0;
            return encrypted.slice(ivLen, encrypted.size() - padLen - ivLen);
        }
        int padLen = 0;
        int ivLen = 0;
        if (this.cipher != null) {
            Ex.MUST(crypt.size() % this.blockSize == 0, 20);
            crypt = this.cipher.process(crypt);
            padLen = this.checkPadding(crypt, 0);
            ivLen = this.useExplicitIV ? this.blockSize : 0;
        }
        Binary plain = crypt.slice(ivLen, crypt.size() - padLen - ivLen - this.hmacSize);
        Binary mac = crypt.slice(crypt.size() - padLen - this.hmacSize, this.hmacSize);
        Binary expectedMac = this.calcHMac(recordType, plain);
        Ex.MUST(mac.equals(expectedMac), 20);
        return plain;
    }

    private int checkPadding(Binary data, int macSize) {
        int padLimit;
        int len = data.size();
        int lastByte = data.get(data.size() - 1);
        int padLen = lastByte + 1;
        if (padLen > (padLimit = Math.min(256, len - macSize))) {
            throw new Ex(20);
        }
        int i = len - padLen;
        while (i < len) {
            if (data.get(i) != lastByte) {
                throw new Ex(20);
            }
            ++i;
        }
        return padLen;
    }

    private Binary PRF(Binary data, String label, Binary seed, int length) {
        Binary labelSeed = Binary.Bin().fromUTF8(label).add(seed);
        if (this.session.protocolVersion == 771) {
            HMAC hmac = new HMAC(new SHA256()).setKey(data);
            return TlsPSKCrypt.HMAC_hash(hmac, labelSeed, length);
        }
        int s_half = (data.size() + 1) / 2;
        HMAC hmac1 = new HMAC(new MD5()).setKey(data.first(s_half));
        Binary b1 = TlsPSKCrypt.HMAC_hash(hmac1, labelSeed, length);
        HMAC hmac2 = new HMAC(new SHA1()).setKey(data.last(s_half));
        Binary b2 = TlsPSKCrypt.HMAC_hash(hmac2, labelSeed, length);
        return b1.xor(b2);
    }

    private static Binary HMAC_hash(HMAC hmac, Binary seed, int length) {
        int macSize = hmac.getSize();
        Binary result = Binary.Bin().reserve(length);
        Binary Ai = seed;
        int offset = 0;
        while (offset < length) {
            Ai = hmac.calc(Ai);
            Binary resPart = hmac.calc(Binary.Bin(Ai, seed));
            result.add(resPart, 0, Math.min(macSize, length - offset));
            offset += macSize;
        }
        return result;
    }
}

