/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81;

import java.util.Iterator;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.format.LV;
import org.denom.scp81.TlsHelloClient;
import org.denom.scp81.TlsHelloServer;
import org.denom.scp81.TlsPSKSession;

public class TlsPSKServerSession
extends TlsPSKSession {
    private Binary pskHint = Binary.Bin("");

    public TlsPSKServerSession() {
        super(true);
        this.state = 1;
    }

    public TlsPSKServerSession setPskHint(Binary pskHint) {
        this.pskHint = pskHint.clone();
        return this;
    }

    @Override
    protected void onHandshakeMessage(int type, Binary message, Binary data) {
        switch (type) {
            case 1: {
                this.onClientHello(message, data);
                break;
            }
            case 16: {
                this.onClientKeyExchange(message, data);
                break;
            }
            case 20: {
                this.onClientFinished(message, data);
                break;
            }
            default: {
                throw new Ex(10);
            }
        }
    }

    protected void onClientHello(Binary message, Binary data) {
        Ex.MUST(this.state == 1, 10);
        this.addHandshakeMessage(message);
        TlsHelloClient clientHello = new TlsHelloClient(data);
        this.gotClientHello(clientHello);
        this.log.write(this.colorRecv3, clientHello.toString());
        this.protocolVersion = clientHello.protocol;
        int cipherSuite = 0;
        Iterator<Object> iterator = clientHello.cipherSuites.iterator();
        while (iterator.hasNext()) {
            int suite = (Integer)iterator.next();
            if (!this.cipherSuites.contains(suite)) continue;
            cipherSuite = suite;
            break;
        }
        Ex.MUST(cipherSuite > 0, 47);
        iterator = clientHello.extensions.keySet().iterator();
        while (iterator.hasNext()) {
            int extension = (Integer)iterator.next();
            if (!this.extensions.containsKey(extension)) {
                clientHello.extensions.remove(extension);
            }
            if (extension != 22 || cipherSuite != 44 && cipherSuite != 176) continue;
            clientHello.extensions.remove(extension);
        }
        TlsHelloServer serverHello = new TlsHelloServer(clientHello.protocol, Binary.Bin().randomSecure(32), Binary.Bin(), cipherSuite, clientHello.extensions);
        this.gotServerHello(serverHello);
        this.log.write(this.colorSend3, serverHello.toString());
        this.sendHandshakeMsg(2, serverHello.toBin());
        this.sendHandshakeMsg(12, LV.LV2(this.pskHint));
        this.sendHandshakeMsg(14, Binary.Bin());
        this.state = 2;
    }

    protected void onClientKeyExchange(Binary message, Binary data) {
        Ex.MUST(this.state == 2, 10);
        this.addHandshakeMessage(message);
        int identityLen = data.getU16(0);
        Ex.MUST(data.size() == 2 + identityLen, 50);
        this.identity = data.slice(2, identityLen);
        Ex.MUST(this.funcGetPSK != null, "getPSK not set");
        this.psk = (Binary)this.funcGetPSK.apply(this.identity);
        Ex.MUST(this.psk != null, 47, "No PSK for identity: " + this.identity.Hex());
        this.state = 10;
    }

    protected void onClientFinished(Binary message, Binary data) {
        Ex.MUST(this.state == 11, 10);
        Ex.MUST(data.size() == 12, 50);
        Ex.MUST(this.calcVerifyData(!this.isServer).equals(data), 51);
        this.addHandshakeMessage(message);
        this.finishHandshake();
        this.state = 20;
        this.handshakeMessages = null;
        this.handshakeDone = true;
    }
}

