/*
 * Decompiled with CFR 0.152.
 */
package org.denom.scp81.http;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.denom.Binary;
import org.denom.Ex;

public class HttpReq {
    public static final int COLOR = -16352;
    public String method;
    public String host;
    public String requestTarget;
    public final HashMap<String, String> headers = new HashMap();
    public Binary body = Binary.Bin();

    public HttpReq() {
    }

    public HttpReq(String host, String requestTarget, String method) {
        this.host = host;
        this.requestTarget = requestTarget;
        this.method = method;
        this.addHeader("Host", host);
    }

    public HttpReq addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public HttpReq addHeaderLine(String header) {
        int splitIndex = header.indexOf(58);
        Ex.MUST(splitIndex != -1, "Wrong header");
        this.headers.put(header.substring(0, splitIndex), header.substring(splitIndex + 1).trim());
        return this;
    }

    public HttpReq setBody(Binary bodyBin) {
        this.body = bodyBin;
        return this;
    }

    public String getStartLine() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method);
        sb.append(' ');
        sb.append(this.requestTarget);
        sb.append(' ');
        sb.append("HTTP/1.1\r\n");
        return sb.toString();
    }

    public String getHeadersStr() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> pair : this.headers.entrySet()) {
            sb.append(pair.getKey());
            sb.append(": ");
            sb.append(pair.getValue());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public Binary toBin() {
        String startLine = this.getStartLine();
        String headersStr = this.getHeadersStr();
        String s = String.valueOf(startLine) + headersStr + "\r\n";
        Binary b = Binary.Bin().fromUTF8(s);
        if (this.body != null && !this.body.empty()) {
            b.add(this.body);
        }
        return b;
    }

    public String toString() {
        String s = String.valueOf(this.getStartLine()) + this.getHeadersStr() + "\r\n";
        if (this.body != null && !this.body.empty()) {
            s = String.valueOf(s) + String.format(Locale.US, "Body [%d]: \r\n", this.body.size());
            s = String.valueOf(s) + this.body.Hex(1, 8, 32, 0);
        }
        return s;
    }
}

