/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.Strings;
import org.denom.log.ILog;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.IApduLogger;
import org.denom.smartcard.RApdu;

public class ApduLoggerParsed
implements IApduLogger {
    private ILog log;

    public ApduLoggerParsed(ILog log) {
        this.log = log;
    }

    @Override
    public void setLog(ILog log) {
        this.log = log;
    }

    @Override
    public ILog getLog() {
        return this.log;
    }

    @Override
    public void printPowerOn() {
        this.log.writeln(-8326928, "Power on");
    }

    @Override
    public void printPowerOff() {
        this.log.writeln(-8326928, "Power off");
    }

    @Override
    public void printReset() {
        this.log.writeln(-8326928, "Reset");
    }

    @Override
    public void printATR(Binary atr) {
        this.log.writeln(-8326928, "ATR: " + atr.Hex());
    }

    @Override
    public void printBeforeCommand(CApdu capdu, String callClassName) {
        this.log.writeln(-16744577, "----------------------------------------------------------------");
        this.log.write(-999424, String.valueOf(Strings.currentDateTime()) + " -- ");
        this.log.writeln(-999424, Ex.getCallerPlace(callClassName));
        capdu.print(this.log, -6246208, -8326928, 0);
    }

    @Override
    public void printCApduSM(CApdu capduSM) {
        this.log.writeln(-7303024, "    +++++++++++++++ Secure Messaging +++++++++++++++");
        capduSM.print(this.log, -7303024, 0, 4);
    }

    @Override
    public void printRApduSM(RApdu rapduSM, boolean isTlvData) {
        this.log.writeln(-7303024, "    ~~~~~~~~~~~~~");
        rapduSM.print(this.log, -7303024, 4, isTlvData);
        this.log.writeln(-7303024, "    +++++++++++++++ Secure Messaging +++++++++++++++");
    }

    @Override
    public void printAfterCommand(RApdu rapdu, long commandTime, boolean isTlvData) {
        this.log.writeln(-6246208, "-------------------------");
        rapdu.print(this.log, -4268322, 0, isTlvData);
        this.log.writeln(-4194112, "Command time: " + commandTime + " ms");
        this.log.writeln(-16744577, "----------------------------------------------------------------");
    }
}

