/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import java.util.Arrays;
import java.util.Locale;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.format.BerTLV;
import org.denom.format.BerTLVList;
import org.denom.log.ILog;
import org.denom.log.LogDummy;

public class CApdu {
    public static final int MAX_NE = 256;
    public int cla;
    public int ins;
    public int p1;
    public int p2;
    public Binary data;
    public String description;
    public boolean isTlvData;
    private int Ne;
    private boolean forceExtMode = false;

    public int Nc() {
        return this.data.size();
    }

    public int getNe() {
        return this.Ne;
    }

    public void setNe(int ne) {
        Ex.MUST(ne >= 0 && ne <= 65536, "Wrong Ne");
        this.Ne = ne;
    }

    public CApdu() {
        this.clear();
    }

    public CApdu(Binary bin) {
        this.assign(bin);
    }

    public CApdu(String hex) {
        this(Binary.Bin(hex));
    }

    public CApdu(Binary header, Binary data, int Ne) {
        Ex.MUST(header.size() == 4, "Wrong header size");
        this.cla = header.get(0);
        this.ins = header.get(1);
        this.p1 = header.get(2);
        this.p2 = header.get(3);
        this.data = data.clone();
        this.description = "";
        this.setNe(Ne);
    }

    public CApdu(String header, String data, int Ne) {
        this(Binary.Bin(header), Binary.Bin(data), Ne);
    }

    public CApdu(int cla, int ins, int p1, int p2) {
        this(cla, ins, p1, p2, Binary.Bin(), 0, "");
    }

    public CApdu(int cla, int ins, int p1, int p2, int Ne) {
        this(cla, ins, p1, p2, Binary.Bin(), Ne, "");
    }

    public CApdu(int cla, int ins, int p1, int p2, Binary data) {
        this(cla, ins, p1, p2, data, 0, "");
    }

    public CApdu(int cla, int ins, int p1, int p2, Binary data, int Ne) {
        this(cla, ins, p1, p2, data, Ne, "");
    }

    public CApdu(int cla, int ins, int p1, int p2, Binary data, int Ne, String description) {
        Ex.MUST(Int.isU8(cla) && Int.isU8(ins) && Int.isU8(p1) && Int.isU8(p2) && Int.isU16(data.size()), "Wrong CApdu params");
        this.cla = cla;
        this.ins = ins;
        this.p1 = p1;
        this.p2 = p2;
        this.data = data.clone();
        this.setNe(Ne);
        this.description = description;
    }

    public void assign(Binary bin) {
        this.forceExtMode = false;
        int sz = bin.size();
        Ex.MUST(sz >= 4, "Wrong Command APDU");
        this.cla = bin.get(0);
        this.ins = bin.get(1);
        this.p1 = bin.get(2);
        this.p2 = bin.get(3);
        this.data = Binary.Bin();
        this.Ne = 0;
        this.description = "";
        if (sz == 4) {
            return;
        }
        int b4 = bin.get(4);
        if (sz == 5) {
            this.Ne = b4 != 0 ? b4 : 256;
            return;
        }
        if (b4 != 0) {
            int dataSize = b4;
            Ex.MUST(sz == 5 + dataSize || sz == 6 + dataSize, "Wrong Command APDU. Wrong Lc?");
            this.data = bin.slice(5, dataSize);
            if (sz == 6 + dataSize) {
                int ne = bin.get(5 + dataSize);
                this.Ne = ne != 0 ? ne : 256;
            }
            return;
        }
        this.forceExtMode = true;
        if (sz == 7) {
            int ne = bin.get(5) << 8 | bin.get(6);
            this.Ne = ne != 0 ? ne : 65536;
            return;
        }
        Ex.MUST(sz > 7, "Incorrect Command APDU");
        int dataSize = bin.get(5) << 8 | bin.get(6);
        Ex.MUST(sz == 7 + dataSize || sz == 9 + dataSize, "Wrong Command APDU. Wrong Lc?");
        this.data = bin.slice(7, dataSize);
        if (sz == 9 + dataSize) {
            int ne = bin.get(7 + dataSize) << 8 | bin.get(8 + dataSize);
            this.Ne = ne != 0 ? ne : 65536;
        }
    }

    public void clear() {
        this.cla = 0;
        this.ins = 0;
        this.p1 = 0;
        this.p2 = 0;
        this.data = Binary.Bin();
        this.setNe(0);
        this.description = "";
    }

    public CApdu clone() {
        return new CApdu(this.cla, this.ins, this.p1, this.p2, this.data, this.Ne, this.description);
    }

    public boolean isExtended() {
        return this.data.size() > 255 || this.Ne > 256 || this.forceExtMode;
    }

    public Case getCase() {
        if (this.isExtended()) {
            if (this.data.size() != 0) {
                return this.Ne != 0 ? Case.CASE_4E : Case.CASE_3E;
            }
            return this.Ne != 0 ? Case.CASE_2E : Case.CASE_1;
        }
        if (this.data.size() != 0) {
            return this.Ne != 0 ? Case.CASE_4S : Case.CASE_3S;
        }
        return this.Ne != 0 ? Case.CASE_2S : Case.CASE_1;
    }

    public static int addLogicalChannel(int cla, int logicalChannel) {
        Ex.MUST(logicalChannel >= 0 && logicalChannel <= 19, "Wrong logical channel number");
        cla = logicalChannel < 4 ? (cla |= logicalChannel) : (cla |= logicalChannel - 4 | 0x40);
        return cla;
    }

    public CApdu addLogicalChannel(int logicalChannel) {
        this.cla = CApdu.addLogicalChannel(this.cla, logicalChannel);
        return this;
    }

    public static int getLogicalChannel(int cla) {
        if (cla == 255 || (cla & 0xE0) == 32) {
            return 0;
        }
        return (cla & 0x40) != 0 ? (cla & 0xF) + 4 : cla & 3;
    }

    public int getLogicalChannel() {
        return CApdu.getLogicalChannel(this.cla);
    }

    public static int clearLogicalChannel(int cla) {
        return (cla & 0x40) != 0 ? cla & 0xB0 : cla & 0xFC;
    }

    public int clearLogicalChannel() {
        return (this.cla & 0x40) != 0 ? this.cla & 0xB0 : this.cla & 0xFC;
    }

    public Binary toBin() {
        Ex.MUST(this.data.size() <= 65535 && this.Ne >= 0 && this.Ne <= 65536, "Wrong sizes in CApdu");
        Binary result = new Binary();
        result.reserve(9 + this.data.size());
        result.add(this.cla);
        result.add(this.ins);
        result.add(this.p1);
        result.add(this.p2);
        int sz = this.data.size();
        if (sz != 0) {
            if (this.isExtended()) {
                result.add(0);
                result.add(sz >> 8);
            }
            result.add(sz);
            result.add(this.data);
        }
        if (this.Ne != 0) {
            if (this.isExtended()) {
                if (sz == 0) {
                    result.add(0);
                }
                result.add(this.Ne >> 8);
            }
            result.add(this.Ne & 0xFF);
        }
        return result;
    }

    static void printFieldAsTLV(Binary data, ILog log, int color, int lineShift, String shiftStr) {
        if (data.size() > 3 && BerTLV.isTLVList(data)) {
            log.write(color, shiftStr);
            log.writeln(color, "- - - - - - - - - -  As BER-TLV:  - - - - - - - - - -");
            log.writeln(color, new BerTLVList(data).toString(lineShift));
            log.writeln(color, "- - - - - - - - - - - - - - - - - - - - - - - - - - -");
        }
    }

    public void print(ILog log, int colorBytes, int colorDescription, int lineShift) {
        if (log instanceof LogDummy) {
            return;
        }
        String shiftStr = "";
        if (lineShift > 0) {
            char[] arr = new char[lineShift];
            Arrays.fill(arr, ' ');
            shiftStr = new String(arr);
        }
        if (this.description != null && this.description.length() != 0) {
            log.writeln(colorDescription, String.valueOf(shiftStr) + this.description);
        }
        log.writeln(colorBytes, String.valueOf(shiftStr) + "CLA  INS   P1   P2     Ne");
        log.writeln(colorBytes, String.format(Locale.US, "%s %02X   %02X   %02X   %02X     %6$d  (0x%6$X)", shiftStr, this.cla, this.ins, this.p1, this.p2, this.Ne));
        if (!this.data.empty()) {
            log.writeln(colorBytes, String.format(Locale.US, "%1$sData: %2$d (0x%2$X)", shiftStr, this.data.size()));
            log.writeln(colorBytes, this.data.Hex(1, 8, 32, lineShift));
            if (this.isTlvData) {
                CApdu.printFieldAsTLV(this.data, log, colorBytes, lineShift, shiftStr);
            }
        }
    }

    public static enum Case {
        CASE_1,
        CASE_2S,
        CASE_2E,
        CASE_3S,
        CASE_3E,
        CASE_4S,
        CASE_4E;

    }
}

