/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import org.denom.Binary;
import org.denom.Ticker;
import org.denom.log.ILog;
import org.denom.log.LogDummy;
import org.denom.smartcard.ApduLoggerDummy;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.IApduLogger;
import org.denom.smartcard.ISM;
import org.denom.smartcard.RApdu;

public abstract class CardReader
implements AutoCloseable {
    public RApdu rapdu = new RApdu();
    public Binary resp;
    public long cmdTime;
    public long sumTime;
    public Binary atr;
    public String callerClassName;
    protected ILog transportLog;
    protected boolean isTransportLog;
    protected ISM sm;
    protected Ticker ticker;
    private final String thisClassName;
    protected IApduLogger apduLogger;

    protected CardReader() {
        this.resp = this.rapdu.response;
        this.cmdTime = 0L;
        this.sumTime = 0L;
        this.atr = new Binary();
        this.callerClassName = null;
        this.transportLog = null;
        this.sm = null;
        this.ticker = new Ticker();
        this.thisClassName = CardReader.class.getName();
        this.apduLogger = new ApduLoggerDummy();
    }

    public CardReader setTransportLog(ILog log) {
        this.isTransportLog = log != null && !(log instanceof LogDummy);
        this.transportLog = log;
        return this;
    }

    public ILog getTransportLog() {
        return this.transportLog;
    }

    public CardReader setApduLogger(IApduLogger logger) {
        this.apduLogger = logger;
        if (this.apduLogger == null) {
            this.apduLogger = new ApduLoggerDummy();
        }
        return this;
    }

    public IApduLogger getApduLogger() {
        return this.apduLogger;
    }

    public abstract String[] enumReaders();

    public abstract CardReader connect(String var1);

    public abstract void disconnect();

    public abstract String getName();

    public abstract boolean isCardPresent();

    public abstract boolean waitCardPresent(int var1);

    public abstract boolean waitCardRemove(int var1);

    protected abstract Binary powerOnImpl();

    protected abstract void powerOffImpl();

    protected abstract Binary resetImpl();

    public Binary powerOn() {
        this.apduLogger.printPowerOn();
        this.atr = this.powerOnImpl();
        this.apduLogger.printATR(this.atr);
        return this.atr;
    }

    public void powerOff() {
        this.apduLogger.printPowerOff();
        this.powerOffImpl();
    }

    public Binary reset() {
        this.apduLogger.printReset();
        this.atr = this.resetImpl();
        this.apduLogger.printATR(this.atr);
        return this.atr;
    }

    public abstract RApdu transmit(CApdu var1);

    public abstract CardReader getCardChannel(int var1);

    public final RApdu Cmd(CApdu capdu, int expectedStatus) {
        return this.Cmd(this.sm, capdu, expectedStatus);
    }

    public final RApdu Cmd(String capduHex, int expectedStatus) {
        return this.Cmd(new CApdu(capduHex), expectedStatus);
    }

    public final RApdu Cmd(CApdu capdu) {
        return this.Cmd(capdu, 1);
    }

    public final RApdu Cmd(String capduHex) {
        return this.Cmd(new CApdu(capduHex), 1);
    }

    public final RApdu Cmd(String headerHex, String dataFieldHex, int Ne) {
        return this.Cmd(new CApdu(headerHex, dataFieldHex, Ne), 1);
    }

    public RApdu Cmd(ISM sm, CApdu capdu, int expectedStatus) {
        String callClassName = this.callerClassName == null ? this.thisClassName : this.callerClassName;
        this.callerClassName = null;
        this.apduLogger.printBeforeCommand(capdu, callClassName);
        boolean isTlvData = capdu.isTlvData;
        if (sm != null) {
            capdu = sm.encryptCommand(capdu);
            this.apduLogger.printCApduSM(capdu);
        }
        this.ticker.restart();
        this.rapdu = this.transmit(capdu);
        this.resp = this.rapdu.response;
        this.cmdTime = this.ticker.getDiffMs();
        this.sumTime += this.cmdTime;
        if (sm != null) {
            this.apduLogger.printRApduSM(this.rapdu, false);
            if (this.rapdu.isOk()) {
                this.rapdu = sm.decryptResponse(this.rapdu);
                this.resp = this.rapdu.response;
            }
        }
        this.apduLogger.printAfterCommand(this.rapdu, this.cmdTime, isTlvData);
        this.rapdu.checkStatus(expectedStatus, callClassName);
        return this.rapdu;
    }

    public final RApdu Cmd(ISM sm, CApdu capdu) {
        return this.Cmd(sm, capdu, 1);
    }

    public final void setSM(ISM sm) {
        this.sm = sm;
    }

    public final ISM getSM() {
        return this.sm;
    }

    @Override
    public abstract void close();
}

