/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.log.ILog;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.CardReader;
import org.denom.smartcard.IApduLogger;
import org.denom.smartcard.ISM;
import org.denom.smartcard.RApdu;

public class CardReaderChannel
extends CardReader {
    private final CardReader actualReader;
    private final int logicalChannel;

    public CardReaderChannel(CardReader actualReader, int logicalChannel) {
        Ex.MUST(actualReader != null, "null, No Reader");
        this.actualReader = actualReader;
        this.logicalChannel = logicalChannel;
    }

    public int getChannelNumber() {
        return this.logicalChannel;
    }

    CardReader getActualReader() {
        return this.actualReader;
    }

    @Override
    public final RApdu Cmd(ISM sm, CApdu capdu, int expectedStatus) {
        this.rapdu = this.actualReader.Cmd(sm, capdu.addLogicalChannel(this.logicalChannel), expectedStatus).clone();
        this.resp = this.rapdu.response;
        this.cmdTime = this.actualReader.cmdTime;
        this.sumTime += this.cmdTime;
        return this.rapdu;
    }

    @Override
    public RApdu transmit(CApdu capdu) {
        return this.actualReader.transmit(capdu);
    }

    @Override
    public CardReaderChannel getCardChannel(int logicalChannel) {
        return new CardReaderChannel(this.actualReader, logicalChannel);
    }

    @Override
    public CardReaderChannel setTransportLog(ILog log) {
        this.actualReader.setTransportLog(log);
        return this;
    }

    @Override
    public ILog getTransportLog() {
        return this.actualReader.getTransportLog();
    }

    @Override
    public CardReaderChannel setApduLogger(IApduLogger logger) {
        this.actualReader.setApduLogger(logger);
        return this;
    }

    @Override
    public IApduLogger getApduLogger() {
        return this.actualReader.getApduLogger();
    }

    @Override
    public Binary powerOn() {
        this.atr = this.actualReader.powerOn();
        return this.atr;
    }

    @Override
    public void powerOff() {
        this.actualReader.powerOff();
    }

    @Override
    public Binary reset() {
        this.atr = this.actualReader.reset();
        return this.atr;
    }

    @Override
    public String[] enumReaders() {
        return this.actualReader.enumReaders();
    }

    @Override
    public CardReader connect(String readerName) {
        return this.actualReader.connect(readerName);
    }

    @Override
    public void disconnect() {
        this.actualReader.disconnect();
    }

    @Override
    public String getName() {
        return this.actualReader.getName();
    }

    @Override
    public boolean isCardPresent() {
        return this.actualReader.isCardPresent();
    }

    @Override
    public boolean waitCardPresent(int timeoutSec) {
        return this.actualReader.waitCardPresent(timeoutSec);
    }

    @Override
    public boolean waitCardRemove(int timeoutSec) {
        return this.actualReader.waitCardRemove(timeoutSec);
    }

    @Override
    protected Binary powerOnImpl() {
        return this.actualReader.powerOnImpl();
    }

    @Override
    protected void powerOffImpl() {
        this.actualReader.powerOffImpl();
    }

    @Override
    protected Binary resetImpl() {
        return this.actualReader.resetImpl();
    }

    @Override
    public void close() {
        this.actualReader.close();
    }
}

