/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import java.net.InetAddress;
import org.denom.Ex;
import org.denom.format.JSONObject;

public class CardReaderOptions {
    static final String VR_SERVER = "denom.org";
    static final int VR_DEFAULT_PORT = 4256;
    public String type = "?";
    public String pcscName = "";
    public String pcscNativeDll = "";
    public String vrHost = "denom.org";
    public int vrPort = 4256;
    public String vrName = "";
    public String vrClientName = CardReaderOptions.getHostName();
    public String vrPassword = "";

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public CardReaderOptions clone() {
        CardReaderOptions opt = new CardReaderOptions();
        opt.type = this.type;
        opt.pcscName = this.pcscName;
        opt.pcscNativeDll = this.pcscNativeDll;
        opt.vrHost = this.vrHost;
        opt.vrPort = this.vrPort;
        opt.vrName = this.vrName;
        opt.vrClientName = this.vrClientName;
        opt.vrPassword = this.vrPassword;
        return opt;
    }

    public CardReaderOptions fromJSON(JSONObject jo) {
        this.type = jo.getString("Reader Type");
        this.pcscName = jo.optString("PCSC Reader Name");
        this.pcscNativeDll = jo.optString("PCSC Native DLL");
        this.vrHost = jo.optString("VR Host", VR_SERVER);
        this.vrPort = jo.optInt("VR Port", 4256);
        this.vrName = jo.optString("VR Reader Name");
        this.vrClientName = jo.optString("VR Client Name", CardReaderOptions.getHostName());
        this.vrPassword = jo.optString("VR Password");
        return this;
    }

    public JSONObject toJSON() {
        JSONObject rOpt = new JSONObject();
        rOpt.put("Reader Type", this.type);
        rOpt.put("PCSC Reader Name", this.pcscName);
        rOpt.put("PCSC Native DLL", this.pcscNativeDll);
        rOpt.put("VR Host", this.vrHost);
        rOpt.put("VR Port", this.vrPort);
        rOpt.put("VR Reader Name", this.vrName);
        rOpt.put("VR Client Name", this.vrClientName);
        rOpt.put("VR Password", this.vrPassword);
        return rOpt;
    }

    public String getName() {
        switch (this.type) {
            case "PC/SC": {
                return this.pcscName;
            }
            case "PC/SC Native": {
                return this.pcscName;
            }
            case "VR": {
                return this.vrName;
            }
            case "Null": {
                return "Null";
            }
            case "?": {
                return "Unknown";
            }
        }
        Ex.THROW("Unsupported reader type");
        return "";
    }
}

