/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import java.util.List;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.CardReader;
import org.denom.smartcard.CardReaderChannel;
import org.denom.smartcard.RApdu;

public class CardReaderPCSC
extends CardReader {
    private CardChannel channel;
    private Card card;
    private CardTerminal terminal;
    private TerminalFactory factory = TerminalFactory.getDefault();

    @Override
    public String[] enumReaders() {
        try {
            List<CardTerminal> terminals = this.factory.terminals().list();
            String[] names = new String[terminals.size()];
            int i = 0;
            while (i < terminals.size()) {
                names[i] = terminals.get(i).getName();
                ++i;
            }
            return names;
        }
        catch (Throwable ex) {
            return new String[0];
        }
    }

    public static String[] enumerateReaders() {
        return new CardReaderPCSC().enumReaders();
    }

    @Override
    public CardReaderPCSC connect(String readerName) {
        this.disconnect();
        this.terminal = this.factory.terminals().getTerminal(readerName);
        Ex.MUST(this.terminal != null, "No such Card reader with name: " + readerName);
        return this;
    }

    @Override
    public void disconnect() {
        this.powerOffImpl();
        this.terminal = null;
    }

    @Override
    public boolean isCardPresent() {
        this.checkConnected();
        try {
            return this.terminal.isCardPresent();
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public boolean waitCardPresent(int timeoutSec) {
        this.checkConnected();
        try {
            return this.terminal.waitForCardPresent(timeoutSec * 1000);
        }
        catch (CardException ex) {
            return false;
        }
    }

    @Override
    public boolean waitCardRemove(int timeoutSec) {
        this.checkConnected();
        try {
            return this.terminal.waitForCardAbsent(timeoutSec * 1000);
        }
        catch (CardException ex) {
            return false;
        }
    }

    @Override
    protected Binary powerOnImpl() {
        this.powerOffImpl();
        this.checkCardInserted();
        try {
            this.card = this.terminal.connect("*");
            this.channel = this.card.getBasicChannel();
            ATR a = this.card.getATR();
            return new Binary(a.getBytes());
        }
        catch (Throwable ex) {
            Ex.THROW(ex.toString());
            return new Binary();
        }
    }

    @Override
    protected void powerOffImpl() {
        try {
            if (this.card != null) {
                this.channel = null;
                this.card.disconnect(true);
                this.card = null;
            }
        }
        catch (CardException ex) {
            Ex.THROW(ex.toString());
        }
    }

    @Override
    protected Binary resetImpl() {
        this.powerOffImpl();
        return this.powerOnImpl();
    }

    @Override
    public String getName() {
        this.checkConnected();
        return this.terminal.getName();
    }

    @Override
    public RApdu transmit(CApdu capdu) {
        Ex.MUST(this.channel != null, "Card not powered");
        try {
            if (this.isTransportLog) {
                this.transportLog.writeln(" -> " + capdu.toBin().Hex(1, 8, 0, 0));
            }
            ResponseAPDU rapdu = this.channel.transmit(new CommandAPDU(capdu.toBin().getBytes()));
            if (this.isTransportLog) {
                this.transportLog.writeln(" <- " + new Binary(rapdu.getBytes()).Hex(1, 8, 0, 0));
                this.transportLog.writeln("");
            }
            return new RApdu(rapdu.getBytes());
        }
        catch (CardException ex) {
            Ex.MUST(false, ex.toString());
            return null;
        }
    }

    @Override
    public CardReaderChannel getCardChannel(int logicalChannel) {
        return new CardReaderChannel(this, logicalChannel);
    }

    @Override
    public void close() {
        this.disconnect();
    }

    private void checkConnected() {
        Ex.MUST(this.terminal != null, "Not connected to reader");
    }

    private void checkCardInserted() {
        this.checkConnected();
        try {
            if (!this.terminal.isCardPresent()) {
                Ex.THROW("Card not inserted in reader: '" + this.getName() + "'");
            }
        }
        catch (Throwable ex) {
            Ex.THROW(ex.toString());
        }
    }
}

