/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import java.nio.file.Paths;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Strings;
import org.denom.Sys;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.CardReader;
import org.denom.smartcard.CardReaderChannel;
import org.denom.smartcard.RApdu;

public class CardReaderPCSCNative
extends CardReader {
    String PATH_IN_JAR = "bin/CardReaderPCSCNativeJNI.dll";
    private String curReaderName = null;
    private boolean cardPowered = false;
    private static boolean dllLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardReaderPCSCNative(String path) {
        Class<CardReaderPCSCNative> clazz = CardReaderPCSCNative.class;
        synchronized (CardReaderPCSCNative.class) {
            if (!dllLoaded) {
                if (path != null && !path.isEmpty()) {
                    System.load(Paths.get(path, new String[0]).toAbsolutePath().toString());
                } else {
                    try {
                        Sys.loadLibraryFromJar(this.PATH_IN_JAR);
                    }
                    catch (Throwable ex) {
                        System.loadLibrary("CardReaderPCSCNativeJNI");
                    }
                }
                dllLoaded = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String[] enumReaders() {
        return CardReaderPCSCNative.enumerateReaders();
    }

    private void checkConnected() {
        Ex.MUST(this.curReaderName != null, "Not connected to reader");
    }

    @Override
    public CardReaderPCSCNative connect(String readerName) {
        this.disconnect();
        this.connectNative(readerName.getBytes(Strings.UTF8));
        this.curReaderName = readerName;
        return this;
    }

    @Override
    public void disconnect() {
        this.powerOffImpl();
        this.disconnectNative();
        this.curReaderName = null;
    }

    public void openFileLog(String logFileName, boolean isLogApdu, boolean isLogTpdu) {
        this.openFileLogNative(logFileName.getBytes(Strings.UTF8), isLogApdu, isLogTpdu);
    }

    @Override
    public boolean isCardPresent() {
        this.checkConnected();
        try {
            return this.isCardPresentNative();
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public boolean waitCardPresent(int timeoutSec) {
        this.checkConnected();
        try {
            return this.waitCardPresentNative(timeoutSec);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public boolean waitCardRemove(int timeoutSec) {
        this.checkConnected();
        try {
            return this.waitCardRemoveNative(timeoutSec);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    protected Binary powerOnImpl() {
        this.powerOffImpl();
        this.checkConnected();
        byte[] atrArr = this.powerOnNative();
        Binary atr = new Binary(atrArr);
        this.cardPowered = true;
        return atr;
    }

    @Override
    protected void powerOffImpl() {
        if (this.cardPowered) {
            this.powerOffNative();
            this.cardPowered = false;
        }
    }

    @Override
    protected Binary resetImpl() {
        this.powerOffImpl();
        return this.powerOnImpl();
    }

    @Override
    public String getName() {
        this.checkConnected();
        return this.curReaderName;
    }

    @Override
    public RApdu transmit(CApdu capdu) {
        if (this.isTransportLog) {
            this.transportLog.writeln(" -> " + capdu.toBin().Hex(1, 8, 0, 0));
        }
        byte[] rapduArr = this.transmitNative(capdu.toBin().getBytes());
        if (this.isTransportLog) {
            this.transportLog.writeln(" <- " + new Binary(rapduArr).Hex(1, 8, 0, 0));
        }
        return new RApdu(rapduArr);
    }

    @Override
    public CardReaderChannel getCardChannel(int logicalChannel) {
        return new CardReaderChannel(this, logicalChannel);
    }

    @Override
    public void close() {
        this.disconnect();
    }

    private native void openFileLogNative(byte[] var1, boolean var2, boolean var3);

    private static native String[] enumerateReaders();

    private native void connectNative(byte[] var1);

    private native void disconnectNative();

    private native boolean isCardPresentNative();

    private native boolean waitCardPresentNative(int var1);

    private native boolean waitCardRemoveNative(int var1);

    private native void powerOffNative();

    private native byte[] powerOnNative();

    private native byte[] transmitNative(byte[] var1);
}

