/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import org.denom.Arr;
import org.denom.Binary;
import org.denom.log.ILog;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.CardReader;
import org.denom.smartcard.CardReaderChannel;
import org.denom.smartcard.RApdu;
import org.denom.smartcard.VirtualReaderClient;

public class CardReaderVRSocket
extends CardReader {
    protected int readerHandle = 0;
    protected String readerName = "";
    protected boolean isPowered = false;
    protected boolean isConnectedToReader = false;
    protected VirtualReaderClient vrClient = new VirtualReaderClient();

    public CardReaderVRSocket connectToVR(String vrHost, int vrPort) {
        return this.connectToVR(vrHost, vrPort, 10);
    }

    public CardReaderVRSocket connectToVR(String vrHost, int vrPort, int connectTimeoutSec) {
        this.disconnectFromVR();
        this.vrClient = new VirtualReaderClient(vrHost, vrPort, connectTimeoutSec);
        return this;
    }

    public void disconnectFromVR() {
        this.disconnect();
        this.vrClient.close();
        this.vrClient = new VirtualReaderClient();
    }

    public void setReadTimeoutSec(int sec) {
        this.vrClient.setReadTimeoutSec(sec);
    }

    public int getReadTimeoutSec() {
        return this.vrClient.getReadTimeoutSec();
    }

    public Arr<Integer> enumCommands() {
        return this.vrClient.commandEnumCommands();
    }

    @Override
    public String[] enumReaders() {
        return this.vrClient.commandEnumReaders();
    }

    @Override
    public CardReader connect(String readerName) {
        return this.connect("John Doe", readerName, "");
    }

    public CardReader connect(String clientName, String readerName, String password) {
        this.disconnect();
        this.readerHandle = this.vrClient.commandConnect(clientName, readerName, password);
        this.readerName = readerName;
        this.isConnectedToReader = true;
        return this;
    }

    @Override
    public void disconnect() {
        if (!this.isConnectedToReader) {
            return;
        }
        this.powerOffImpl();
        try {
            this.vrClient.commandDisconnect(this.readerHandle);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.readerHandle = 0;
        this.readerName = "";
        this.isConnectedToReader = false;
    }

    @Override
    public boolean isCardPresent() {
        return this.vrClient.commandIsCardPresent(this.readerHandle);
    }

    @Override
    public boolean waitCardPresent(int timeoutSec) {
        return this.vrClient.commandWaitCardPresent(this.readerHandle, timeoutSec);
    }

    @Override
    public boolean waitCardRemove(int timeoutSec) {
        return this.vrClient.commandWaitCardRemove(this.readerHandle, timeoutSec);
    }

    @Override
    protected Binary powerOnImpl() {
        this.powerOff();
        Binary atr = this.vrClient.commandPowerOn(this.readerHandle);
        this.isPowered = true;
        return atr;
    }

    @Override
    protected void powerOffImpl() {
        if (!this.isPowered) {
            return;
        }
        try {
            this.vrClient.commandPowerOff(this.readerHandle);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.isPowered = false;
    }

    @Override
    protected Binary resetImpl() {
        return this.vrClient.commandReset(this.readerHandle);
    }

    @Override
    public String getName() {
        return this.readerName;
    }

    @Override
    public RApdu transmit(CApdu capdu) {
        return this.vrClient.commandCmd(this.readerHandle, capdu);
    }

    @Override
    public CardReaderChannel getCardChannel(int logicalChannel) {
        return new CardReaderChannel(this, logicalChannel);
    }

    @Override
    public CardReader setTransportLog(ILog log) {
        super.setTransportLog(log);
        this.vrClient.setLog(log);
        return this;
    }

    @Override
    public void close() {
        this.disconnectFromVR();
    }
}

