/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Strings;
import org.denom.Ticker;
import org.denom.log.ILog;
import org.denom.log.LogColoredConsoleWindow;
import org.denom.log.LogConsole;
import org.denom.log.LogConsoleANSI;
import org.denom.log.LogDummy;
import org.denom.log.LogFile;
import org.denom.smartcard.ApduLoggerDummy;
import org.denom.smartcard.ApduLoggerMinimal;
import org.denom.smartcard.ApduLoggerParsed;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.CardReader;
import org.denom.smartcard.CardReaderNull;
import org.denom.smartcard.CardReaderOptions;
import org.denom.smartcard.CardReaderPCSC;
import org.denom.smartcard.CardReaderPCSCNative;
import org.denom.smartcard.ISM;
import org.denom.smartcard.RApdu;
import org.denom.smartcard.ReaderFactory;
import org.denom.smartcard.VirtualReaderClient;

public abstract class CardScript
implements Runnable {
    public Options opt = new Options();
    public CardReader cr = new CardReaderNull();
    public RApdu rapdu;
    public Binary resp;
    public ILog log;
    protected Random rand;
    private static final String className = CardScript.class.getName();
    private static final String MODEL_PREFIX = "vc";
    private ILog consoleLog;

    public CardScript() {
        this.rapdu = this.cr.rapdu;
        this.resp = this.cr.resp;
        this.log = new LogDummy();
        this.rand = new Random(System.nanoTime());
        this.consoleLog = new LogDummy();
    }

    public void Main() {
        this.initLog();
        try {
            this.log.writeln(-7303024, "==================================================================");
            this.log.writeln(-8326928, "Current time: " + Strings.currentDateTime());
            this.cr = this.createReader(this.opt.reader);
            if (this.opt.log.tpdu) {
                this.cr.setTransportLog(this.log);
            }
            if (this.opt.log.apdu == 3) {
                this.cr.setApduLogger(new ApduLoggerMinimal(this.log).setPrintCallPlace(true).setPrintDescription(true).setPrintCommandTime(true));
            }
            if (this.opt.log.apdu == 2) {
                this.cr.setApduLogger(new ApduLoggerParsed(this.log));
            }
            if (this.opt.log.apdu == 1) {
                this.cr.setApduLogger(new ApduLoggerMinimal(this.log));
            }
            if (this.opt.log.apdu == 0) {
                this.cr.setApduLogger(new ApduLoggerDummy());
            }
            Ticker t = new Ticker();
            if (!(this.cr instanceof CardReaderNull)) {
                this.cr.powerOn();
            }
            this.log.writeln(-1040144, "-- Script begin --");
            this.run();
            this.log.writeln(-1040144, "-- Script end --");
            if (!(this.cr instanceof CardReaderNull)) {
                this.cr.powerOff();
            }
            this.cr.close();
            this.log.writeln(-1040144, "Summary command time = " + this.cr.sumTime + " ms");
            this.log.writeln(-1040144, "Summary time = " + t.getDiffMs() + " ms");
        }
        catch (Throwable ex) {
            this.log.writeln(-65536, "Error: " + Ex.getErrorDescription(ex));
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0441\u043a\u0440\u0438\u043f\u0442\u0430");
        }
    }

    public final void Cmd(CApdu capdu, int expectedStatus) {
        this.cr.callerClassName = className;
        this.rapdu = this.cr.Cmd(capdu, expectedStatus);
        this.resp = this.rapdu.response;
    }

    public final void Cmd(String capduHex, int expectedStatus) {
        this.Cmd(new CApdu(capduHex), expectedStatus);
    }

    public final void Cmd(CApdu capdu) {
        this.Cmd(capdu, 1);
    }

    public final void Cmd(String capduHex) {
        this.Cmd(new CApdu(capduHex), 1);
    }

    public final void Cmd(String headerHex, String dataFieldHex, int Ne) {
        this.Cmd(new CApdu(headerHex, dataFieldHex, Ne), 1);
    }

    public final void Cmd(ISM sm, CApdu capdu, int expectedStatus) {
        this.cr.callerClassName = className;
        this.rapdu = this.cr.Cmd(sm, capdu, expectedStatus);
        this.resp = this.rapdu.response;
    }

    public final void Cmd(ISM sm, CApdu capdu) {
        this.Cmd(sm, capdu, 1);
    }

    public void write(String text) {
        this.log.write(text);
    }

    public void write(int color, String text) {
        this.log.write(color, text);
    }

    public void writeln(String text) {
        this.log.writeln(text);
    }

    public void writeln(int color, String text) {
        this.log.writeln(color, text);
    }

    public void checkResp(Binary needResponse) {
        Ex.MUST(needResponse.equals(this.cr.resp), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 \u043a\u0430\u0440\u0442\u044b");
    }

    public void checkResp(String needResponse) {
        this.checkResp(new Binary(needResponse));
    }

    private void initLog() {
        String logName = this.getClass().getSimpleName();
        if (this.opt.log.console == 1) {
            this.consoleLog = new LogConsole();
        } else if (this.opt.log.console == 2) {
            LogColoredConsoleWindow log = new LogColoredConsoleWindow(logName);
            log.setDefaultColor(-16732416);
            this.consoleLog = log;
        } else if (this.opt.log.console == 3) {
            this.consoleLog = new LogConsoleANSI();
        }
        this.log = this.consoleLog;
        if (this.opt.log.file) {
            this.log = new LogFile(String.valueOf(logName) + ".log", true).setNext(this.consoleLog);
        }
    }

    public String readln() {
        String str = "";
        if (this.consoleLog instanceof LogColoredConsoleWindow) {
            str = ((LogColoredConsoleWindow)this.consoleLog).readln();
            this.log.writeln(-3968, str);
        } else {
            Scanner sc = new Scanner(System.in);
            if (sc.hasNext()) {
                str = sc.next();
            }
        }
        return str;
    }

    private void chooseVrReader(CardReaderOptions opt) {
        if (opt.vrName == null || opt.vrName.isEmpty()) {
            String[] names;
            Throwable throwable = null;
            Object var4_4 = null;
            try (VirtualReaderClient client = new VirtualReaderClient(opt.vrHost, opt.vrPort);){
                names = client.commandEnumReaders();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ArrayList<String> arr = new ArrayList<String>(names.length);
            ArrayList<String> models = new ArrayList<String>(names.length);
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.startsWith(MODEL_PREFIX)) {
                    models.add(name);
                } else {
                    arr.add(name);
                }
                ++n2;
            }
            if (!models.isEmpty()) {
                arr.add(MODEL_PREFIX);
            }
            this.log.writeln(-7303024, "VR Host - " + opt.vrHost + ":" + opt.vrPort);
            opt.vrName = this.makeChoice("Choose VR Reader Name:", arr);
            if (opt.vrName.equals(MODEL_PREFIX)) {
                this.log.writeln(-7303024, "VR Host - " + opt.vrHost + ":" + opt.vrPort);
                opt.vrName = this.makeChoice("Choose VR Model:", models);
            }
        }
    }

    public void chooseReaderType(CardReaderOptions opt) {
        block13: {
            String choice;
            if (opt.type != null && !opt.type.isEmpty() && !opt.type.equals("?")) break block13;
            this.log.writeln(-7303024, "PC/SC readers:");
            String[] pcscReaders = CardReaderPCSC.enumerateReaders();
            int i = 0;
            while (i < pcscReaders.length) {
                this.log.writeln(-7303024, "  " + (i + 1) + " - " + pcscReaders[i]);
                ++i;
            }
            this.log.writeln(-7303024, "Virtual readers:");
            this.log.writeln(-7303024, "  q - VR");
            this.log.write(-3968, "Enter reader index (+10 for PC/SC Native) : ");
            switch (choice = this.readln()) {
                case "Q": 
                case "q": {
                    opt.type = "VR";
                    break;
                }
                default: {
                    int index = Integer.parseInt(choice);
                    Ex.MUST(index > 0 && index <= pcscReaders.length || index > 10 && index <= pcscReaders.length + 10, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0440\u0438\u0434\u0435\u0440\u0430");
                    if (index > 10) {
                        opt.type = "PC/SC Native";
                        index -= 10;
                    } else {
                        opt.type = "PC/SC";
                    }
                    opt.pcscName = pcscReaders[index - 1];
                }
            }
        }
        if (opt.type.equals("VR")) {
            this.chooseVrReader(opt);
        }
    }

    public CardReader createReader(CardReaderOptions opt) {
        this.chooseReaderType(opt);
        this.log.writeln(-1040144, "Reader Type:  " + opt.type);
        String nameStr = "";
        switch (opt.type) {
            case "PC/SC": {
                nameStr = "PC/SC name:  " + opt.pcscName;
                if (!opt.pcscName.startsWith("#")) break;
                Ex.MUST(opt.pcscName.length() == 2, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f PC/SC \u0440\u0438\u0434\u0435\u0440\u0430");
                int index = Integer.parseInt(opt.pcscName.substring(1));
                String[] pcscReaders = CardReaderPCSC.enumerateReaders();
                Ex.MUST(index > 0 && index <= pcscReaders.length, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 PC/SC \u0440\u0438\u0434\u0435\u0440\u0430");
                nameStr = String.valueOf(nameStr) + "  =  " + pcscReaders[index - 1];
                break;
            }
            case "PC/SC Native": {
                nameStr = "PC/SC name:  " + opt.pcscName;
                if (!opt.pcscName.startsWith("#")) break;
                Ex.MUST(opt.pcscName.length() == 2, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f PC/SC \u0440\u0438\u0434\u0435\u0440\u0430");
                int index = Integer.parseInt(opt.pcscName.substring(1));
                CardReaderPCSCNative r = new CardReaderPCSCNative(opt.pcscNativeDll);
                String[] pcscReaders = r.enumReaders();
                r.close();
                Ex.MUST(index > 0 && index <= pcscReaders.length, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 PC/SC \u0440\u0438\u0434\u0435\u0440\u0430");
                nameStr = String.valueOf(nameStr) + "  =  " + pcscReaders[index - 1];
                break;
            }
            case "VR": {
                nameStr = "VR: " + opt.vrHost + ":" + opt.vrPort + ", name: " + opt.vrName;
                break;
            }
            case "Null": {
                this.cr = new CardReaderNull();
                break;
            }
            default: {
                Ex.THROW("Unknown Reader Type");
            }
        }
        this.log.writeln(-1040144, nameStr);
        return ReaderFactory.create(opt, true);
    }

    public String makeChoice(String description, List<?> values) {
        this.log.writeln(-7303024, description);
        int i = 0;
        while (i < values.size()) {
            this.log.writeln(-7303024, String.valueOf(i + 1) + " - " + values.get(i).toString());
            ++i;
        }
        this.log.write(-3968, "Enter index: ");
        int choice = Integer.parseInt(this.readln());
        Ex.MUST(choice > 0 && choice <= values.size(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441");
        return values.get(choice - 1).toString();
    }

    public static class LogOptions {
        public int console = 2;
        public boolean file = false;
        public int apdu = 3;
        public boolean tpdu = false;
    }

    public static class Options {
        public CardReaderOptions reader = new CardReaderOptions();
        public LogOptions log = new LogOptions();
    }
}

