/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;

public final class CpsDataGroup {
    public int dgi;
    public final Binary data;
    public String description;
    public boolean needEncryption;

    public CpsDataGroup(int dgi, Binary value, String description) {
        Ex.MUST(Int.isU16(dgi), "Too large DGI, more than 2 bytes");
        this.dgi = dgi;
        this.data = value.clone();
        this.description = description;
    }

    public CpsDataGroup(int dgi, Binary data, boolean needEncryption, String description) {
        Ex.MUST(Int.isU16(dgi), "Too large DGI, more than 2 bytes");
        this.dgi = dgi;
        this.data = data.clone();
        this.description = description;
        this.needEncryption = needEncryption;
    }

    public Binary serialize() {
        Binary res = new Binary().reserve(this.data.size() + 5);
        res.addU16(this.dgi);
        if (this.data.size() < 255) {
            res.add(this.data.size());
        } else {
            res.add(255);
            res.addU16(this.data.size());
        }
        res.add(this.data);
        return res;
    }
}

