/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import java.net.InetAddress;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.denom.smartcard.CardReaderOptions;
import org.denom.smartcard.CardReaderPCSC;
import org.denom.smartcard.CardReaderVRSocket;
import org.denom.swing.SwingUtils;

public class PanelSelectReader
extends JPanel {
    public static final String VR_SERVER = "denom.org";
    public static final int VR_DEFAULT_PORT = 4256;
    private JRadioButton mRadio_PCSC = new JRadioButton("PC/SC Reader");
    private JComboBox<String> mCombo_PCSC;
    private JButton mButton_PCSCRefresh;
    private JRadioButton mRadio_VR;
    private JLabel mLabel_VRName;
    private JComboBox<String> mCombo_VR;
    private JLabel mLabel_VRHost;
    private JTextField mText_VRHost;
    private JButton mButton_GetVRList;
    private JLabel mLabel_VRClientName;
    private JTextField mText_VRClientName;
    private JLabel mLabel_VRPassword;
    private JTextField mText_VRPassword;
    private static final long serialVersionUID = 1L;

    public PanelSelectReader() {
        this(new CardReaderOptions());
    }

    public PanelSelectReader(CardReaderOptions opt) {
        this.mRadio_PCSC.addActionListener(e -> this.enableComponents(this.mCombo_PCSC));
        this.mCombo_PCSC = new JComboBox();
        String[] stringArray = CardReaderPCSC.enumerateReaders();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String reader = stringArray[n2];
            this.mCombo_PCSC.addItem(reader);
            ++n2;
        }
        this.mButton_PCSCRefresh = new JButton("Refresh");
        this.mButton_PCSCRefresh.addActionListener(e -> this.onRefreshPCSC());
        this.mRadio_VR = new JRadioButton("Virtual Reader");
        this.mRadio_VR.addActionListener(e -> this.enableComponents(this.mCombo_VR));
        this.mLabel_VRName = new JLabel("Reader name");
        this.mCombo_VR = new JComboBox();
        this.mCombo_VR.setEditable(true);
        this.mButton_GetVRList = new JButton("Get list");
        this.mButton_GetVRList.addActionListener(e -> this.onGetVRList());
        this.mLabel_VRHost = new JLabel("Server address");
        this.mText_VRHost = SwingUtils.CreateLimitedTextField(128);
        this.mText_VRHost.setToolTipText("<html>Examples: <br>1) Default port:  <i>denom.org</i><br>2) <i>127.0.0.1</i><br>3) With port:  <i>some.domain.ru:5678</i></html>");
        this.mLabel_VRClientName = new JLabel("Client name");
        this.mText_VRClientName = SwingUtils.CreateLimitedTextField(128);
        this.mText_VRClientName.setToolTipText("How to introduce myself when connecting to the reader?");
        this.mLabel_VRPassword = new JLabel("Password");
        this.mText_VRPassword = SwingUtils.CreateLimitedTextField(128);
        this.mText_VRPassword.setToolTipText("Password to connect to the specified reader");
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this.mRadio_PCSC);
        radioGroup.add(this.mRadio_VR);
        this.mRadio_PCSC.setSelected(true);
        int prefSize = -2;
        int compHeight = 30;
        GroupLayout group = new GroupLayout(this);
        group.setHorizontalGroup(group.createParallelGroup().addComponent(this.mRadio_PCSC, prefSize, 182, prefSize).addGroup(group.createSequentialGroup().addGap(28).addComponent(this.mCombo_PCSC, prefSize, 432, prefSize).addComponent(this.mButton_PCSCRefresh, prefSize, 180, prefSize)).addComponent(this.mRadio_VR, prefSize, 190, prefSize).addGroup(group.createSequentialGroup().addGap(30).addComponent(this.mLabel_VRHost, prefSize, 130, prefSize).addComponent(this.mText_VRHost, prefSize, 300, prefSize)).addGroup(group.createSequentialGroup().addGap(54).addComponent(this.mLabel_VRName, prefSize, 106, prefSize).addComponent(this.mCombo_VR, prefSize, 300, prefSize).addComponent(this.mButton_GetVRList, prefSize, 180, prefSize)).addGroup(group.createSequentialGroup().addGap(75).addComponent(this.mLabel_VRPassword, prefSize, 85, prefSize).addComponent(this.mText_VRPassword, prefSize, 160, prefSize)).addGroup(group.createSequentialGroup().addGap(55).addComponent(this.mLabel_VRClientName, prefSize, 105, prefSize).addComponent(this.mText_VRClientName, prefSize, 160, prefSize)));
        group.setVerticalGroup(group.createSequentialGroup().addComponent(this.mRadio_PCSC, prefSize, compHeight, prefSize).addGroup(group.createParallelGroup().addComponent(this.mCombo_PCSC, prefSize, compHeight, prefSize).addComponent(this.mButton_PCSCRefresh, prefSize, compHeight, prefSize)).addGap(10).addComponent(this.mRadio_VR, prefSize, compHeight, prefSize).addGroup(group.createParallelGroup().addComponent(this.mLabel_VRHost, prefSize, compHeight, prefSize).addComponent(this.mText_VRHost, prefSize, compHeight, prefSize)).addGroup(group.createParallelGroup().addComponent(this.mLabel_VRName, prefSize, compHeight, prefSize).addComponent(this.mCombo_VR, prefSize, compHeight, prefSize).addComponent(this.mButton_GetVRList, prefSize, compHeight, prefSize)).addGroup(group.createParallelGroup().addComponent(this.mLabel_VRPassword, prefSize, compHeight, prefSize).addComponent(this.mText_VRPassword, prefSize, compHeight, prefSize)).addGroup(group.createParallelGroup().addComponent(this.mLabel_VRClientName, prefSize, compHeight, prefSize).addComponent(this.mText_VRClientName, prefSize, compHeight, prefSize)));
        this.setLayout(group);
        this.fromOpt(opt);
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public void fromOpt(CardReaderOptions opt) {
        this.mCombo_PCSC.setSelectedItem(opt.pcscName);
        this.mCombo_VR.setSelectedItem(opt.vrName);
        String host = opt.vrHost.trim();
        if (host.isEmpty()) {
            this.mText_VRHost.setText("denom.org:" + String.valueOf(opt.vrPort));
        } else {
            this.mText_VRHost.setText(String.valueOf(host) + ":" + String.valueOf(opt.vrPort));
        }
        if (opt.vrClientName.isEmpty()) {
            this.mText_VRClientName.setText(PanelSelectReader.getHostName());
        } else {
            this.mText_VRClientName.setText(opt.vrClientName);
        }
        this.mText_VRPassword.setText(opt.vrPassword);
        switch (opt.type) {
            case "?": 
            case "PC/SC": {
                this.mRadio_PCSC.setSelected(true);
                this.enableComponents(this.mCombo_PCSC);
                break;
            }
            case "VR": {
                this.mRadio_VR.setSelected(true);
                this.enableComponents(this.mCombo_VR);
                break;
            }
        }
    }

    private String getHost() {
        return this.mText_VRHost.getText().split(":")[0];
    }

    private int getPort() {
        String[] arr = this.mText_VRHost.getText().split(":");
        int port = 4256;
        if (arr.length > 1) {
            try {
                port = Integer.parseInt(arr[1]);
            }
            catch (Throwable ex) {
                port = 0;
            }
        }
        return port;
    }

    public void toOpt(CardReaderOptions opt) {
        opt.pcscName = "";
        if (this.mCombo_PCSC.getSelectedItem() != null) {
            opt.pcscName = this.mCombo_PCSC.getSelectedItem().toString();
        }
        if (this.mCombo_VR.getSelectedItem() != null) {
            opt.vrName = this.mCombo_VR.getSelectedItem().toString();
        }
        opt.vrHost = this.getHost();
        opt.vrPort = this.getPort();
        opt.vrClientName = this.mText_VRClientName.getText();
        opt.vrPassword = this.mText_VRPassword.getText();
        if (this.mRadio_PCSC.isSelected()) {
            opt.type = "PC/SC";
        } else if (this.mRadio_VR.isSelected()) {
            opt.type = "VR";
        }
    }

    public CardReaderOptions toOpt() {
        CardReaderOptions opt = new CardReaderOptions();
        this.toOpt(opt);
        return opt;
    }

    public void setEnabledComponents(boolean enabled) {
        this.mRadio_PCSC.setEnabled(enabled);
        this.mRadio_VR.setEnabled(enabled);
        this.mCombo_PCSC.setEnabled(enabled);
        this.mButton_PCSCRefresh.setEnabled(enabled);
        this.mLabel_VRHost.setEnabled(enabled);
        this.mText_VRHost.setEnabled(enabled);
        this.mLabel_VRName.setEnabled(enabled);
        this.mCombo_VR.setEnabled(enabled);
        this.mButton_GetVRList.setEnabled(enabled);
        this.mLabel_VRClientName.setEnabled(enabled);
        this.mText_VRClientName.setEnabled(enabled);
        this.mLabel_VRPassword.setEnabled(enabled);
        this.mText_VRPassword.setEnabled(enabled);
        if (enabled) {
            if (this.mRadio_PCSC.isSelected()) {
                this.enableComponents(this.mCombo_PCSC);
            } else {
                this.enableComponents(this.mCombo_VR);
            }
        }
    }

    private void onRefreshPCSC() {
        Object currentSelected = this.mCombo_PCSC.getSelectedItem();
        String[] readers = CardReaderPCSC.enumerateReaders();
        this.mCombo_PCSC.removeAllItems();
        String[] stringArray = readers;
        int n = readers.length;
        int n2 = 0;
        while (n2 < n) {
            String reader = stringArray[n2];
            this.mCombo_PCSC.addItem(reader);
            ++n2;
        }
        this.mCombo_PCSC.setSelectedItem(currentSelected);
    }

    private void onGetVRList() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (CardReaderVRSocket reader = new CardReaderVRSocket();){
                reader.connectToVR(this.getHost(), this.getPort());
                String[] readerNames = reader.enumReaders();
                this.mCombo_VR.removeAllItems();
                String[] stringArray = readerNames;
                int n = readerNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String readerName = stringArray[n2];
                    this.mCombo_VR.addItem(readerName);
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            SwingUtils.showMessage(this.getParent(), "Failed to get the list of readers", "Warning", 2);
        }
    }

    private void enableComponents(JComponent comp) {
        this.mCombo_PCSC.setEnabled(comp == this.mCombo_PCSC);
        this.mButton_PCSCRefresh.setEnabled(comp == this.mCombo_PCSC);
        boolean isVR = comp == this.mCombo_VR;
        this.mLabel_VRHost.setEnabled(isVR);
        this.mText_VRHost.setEnabled(isVR);
        this.mLabel_VRName.setEnabled(isVR);
        this.mCombo_VR.setEnabled(isVR);
        this.mButton_GetVRList.setEnabled(isVR);
        this.mLabel_VRClientName.setEnabled(isVR);
        this.mText_VRClientName.setEnabled(isVR);
        this.mLabel_VRPassword.setEnabled(isVR);
        this.mText_VRPassword.setEnabled(isVR);
        comp.requestFocusInWindow();
    }
}

