/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import javax.swing.JOptionPane;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.CardReader;
import org.denom.smartcard.CardReaderNull;
import org.denom.smartcard.CardReaderOptions;
import org.denom.smartcard.CardReaderPCSC;
import org.denom.smartcard.CardReaderPCSCNative;
import org.denom.smartcard.CardReaderVRSocket;

public class ReaderFactory {
    public static CardReader create(CardReaderOptions opt, boolean allowAskPassword) {
        switch (opt.type) {
            case "PC/SC": {
                CardReaderPCSC readerPCSC = new CardReaderPCSC();
                String readerName = opt.pcscName;
                if (opt.pcscName.startsWith("#")) {
                    Ex.MUST(opt.pcscName.length() > 1, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f PC/SC \u0440\u0438\u0434\u0435\u0440\u0430");
                    int index = Integer.parseInt(opt.pcscName.substring(1));
                    String[] readerNames = CardReaderPCSC.enumerateReaders();
                    readerName = readerNames[index - 1];
                }
                readerPCSC.connect(readerName);
                return readerPCSC;
            }
            case "PC/SC Native": {
                CardReaderPCSCNative readerPCSCNative = new CardReaderPCSCNative(opt.pcscNativeDll);
                String readerName = opt.pcscName;
                if (opt.pcscName.startsWith("#")) {
                    Ex.MUST(opt.pcscName.length() > 1, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f PC/SC \u0440\u0438\u0434\u0435\u0440\u0430");
                    int index = Integer.parseInt(opt.pcscName.substring(1));
                    String[] readerNames = CardReaderPCSC.enumerateReaders();
                    readerName = readerNames[index - 1];
                }
                readerPCSCNative.connect(readerName);
                return readerPCSCNative;
            }
            case "VR": {
                CardReaderVRSocket readerVR = new CardReaderVRSocket().connectToVR(opt.vrHost, opt.vrPort);
                try {
                    readerVR.connect(opt.vrClientName, opt.vrName, opt.vrPassword);
                }
                catch (Throwable ex) {
                    String wrongPasswordErrorCode = Binary.Num_Bin(0xE0000008L, 4).Hex();
                    if (allowAskPassword && ex.toString().contains(wrongPasswordErrorCode)) {
                        try {
                            String newPass = JOptionPane.showInputDialog(null, "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c:", "\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0440\u0438\u0434\u0435\u0440\u0443 \"" + opt.vrName + "\"", 3);
                            opt.vrPassword = newPass == null ? "" : newPass;
                            readerVR.connect(opt.vrClientName, opt.vrName, opt.vrPassword);
                        }
                        catch (Throwable ex2) {
                            readerVR.disconnectFromVR();
                            throw ex2;
                        }
                    }
                    readerVR.disconnectFromVR();
                    throw ex;
                }
                return readerVR;
            }
        }
        return new CardReaderNull();
    }
}

