/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.format.LV;
import org.denom.net.SocketClient;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.RApdu;
import org.denom.vrcp.VRCPClient;

public class VirtualReaderClient
extends VRCPClient {
    public static final int ENUM_READERS = -1073741822;
    public static final int CONNECT = -1073741821;
    public static final int DISCONNECT = -1073741820;
    public static final int IS_CARD_PRESENT = -1073741819;
    public static final int POWER_ON = -1073741818;
    public static final int POWER_OFF = -1073741817;
    public static final int RESET = -1073741816;
    public static final int CMD = -1073741815;
    public static final int WAIT_CARD_PRESENT = -1073741808;
    public static final int WAIT_CARD_REMOVE = -1073741807;
    public static final int ATTACH_READER = -1073741791;
    public static final int REMOVE_READER = -1073741790;
    public static final int CREATE_READER = -1073741789;
    private Binary dataBuf = new Binary().reserve(512);

    public VirtualReaderClient() {
    }

    public VirtualReaderClient(SocketClient socketClient) {
        super(socketClient);
    }

    public VirtualReaderClient(String host, int port) {
        this(host, port, 10);
    }

    public VirtualReaderClient(String host, int port, int connectTimeoutSec) {
        super(host, port, connectTimeoutSec);
    }

    public String[] commandEnumReaders() {
        this.command(-1073741822, Binary.Bin());
        return LV.parseLV4Strings(this.vrau.data);
    }

    public void commandCreateModel(String modelName, String connectPassword, String removePassword, Binary cardID, Binary isdAID, Binary sdKeyEnc, Binary sdKeyMac, Binary sdKeyDek) {
        Ex.MUST(cardID.size() == 8 && isdAID.size() >= 5 && isdAID.size() <= 16 && sdKeyEnc.size() == 16 && sdKeyMac.size() == 16 && sdKeyDek.size() == 16, "Wrong card model params");
        String[] arr = new String[]{modelName, connectPassword, removePassword, Binary.Bin(cardID, sdKeyEnc, sdKeyMac, sdKeyDek, isdAID).Hex()};
        this.command(-1073741789, LV.LV4Strings(arr));
    }

    public void commandRemoveModel(String modelName, String removePassword) {
        this.command(-1073741790, LV.LV4Strings(modelName, removePassword));
    }

    public int commandConnect(String clientName, String readerName, String password) {
        this.command(-1073741821, LV.LV4Strings(clientName, readerName, password));
        Ex.MUST(this.vrau.data.size() == 4, "Wrong answer in VR command CONNECT");
        return (int)this.vrau.data.asU32();
    }

    public void commandDisconnect(int readerHandle) {
        this.dataBuf.clear();
        this.dataBuf.addInt(readerHandle);
        this.command(-1073741820, this.dataBuf);
    }

    public boolean commandIsCardPresent(int readerHandle) {
        this.dataBuf.clear();
        this.dataBuf.addInt(readerHandle);
        this.command(-1073741819, this.dataBuf);
        Ex.MUST(this.vrau.data.size() == 1, "Wrong answer in VR command IS CARD PRESENT");
        return this.vrau.data.get(0) != 0;
    }

    public boolean commandWaitCardPresent(int readerHandle, int timeoutSec) {
        this.dataBuf.clear();
        this.dataBuf.addInt(readerHandle);
        this.dataBuf.addInt(timeoutSec);
        this.command(-1073741808, this.dataBuf);
        Ex.MUST(this.vrau.data.size() == 1, "Wrong answer in VR command WAIT CARD PRESENT");
        return this.vrau.data.get(0) != 0;
    }

    public boolean commandWaitCardRemove(int readerHandle, int timeoutSec) {
        this.dataBuf.clear();
        this.dataBuf.addInt(readerHandle);
        this.dataBuf.addInt(timeoutSec);
        this.command(-1073741807, this.dataBuf);
        Ex.MUST(this.vrau.data.size() == 1, "Wrong answer in VR command WAIT CARD REMOVE");
        return this.vrau.data.get(0) != 0;
    }

    public Binary commandPowerOn(int readerHandle) {
        this.dataBuf.clear();
        this.dataBuf.addInt(readerHandle);
        this.command(-1073741818, this.dataBuf);
        return this.vrau.data.clone();
    }

    public void commandPowerOff(int readerHandle) {
        this.dataBuf.clear();
        this.dataBuf.addInt(readerHandle);
        this.command(-1073741817, this.dataBuf);
    }

    public Binary commandReset(int readerHandle) {
        this.dataBuf.clear();
        this.dataBuf.addInt(readerHandle);
        this.command(-1073741816, this.dataBuf);
        return this.vrau.data.clone();
    }

    public RApdu commandCmd(int readerHandle, CApdu capdu) {
        this.dataBuf.clear();
        this.dataBuf.addInt(readerHandle);
        this.dataBuf.add(capdu.toBin());
        this.command(-1073741815, this.dataBuf);
        return new RApdu(this.vrau.data);
    }
}

