/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapFile;
import org.denom.smartcard.cap.ComponentApplet;
import org.denom.smartcard.cap.ComponentClass;
import org.denom.smartcard.cap.ComponentConstantPool;
import org.denom.smartcard.cap.ComponentDebug;
import org.denom.smartcard.cap.ComponentDescriptor;
import org.denom.smartcard.cap.ComponentDirectory;
import org.denom.smartcard.cap.ComponentExport;
import org.denom.smartcard.cap.ComponentHeader;
import org.denom.smartcard.cap.ComponentImport;
import org.denom.smartcard.cap.ComponentMethod;
import org.denom.smartcard.cap.ComponentRefLocation;
import org.denom.smartcard.cap.ComponentStaticField;

public abstract class CapComponent {
    public final CapFile cap;
    public final String fullName;
    public final int tag;
    public static final int TAG_HEADER = 1;
    public static final int TAG_DIRECTORY = 2;
    public static final int TAG_APPLET = 3;
    public static final int TAG_IMPORT = 4;
    public static final int TAG_CONSTANT_POOL = 5;
    public static final int TAG_CLASS = 6;
    public static final int TAG_METHOD = 7;
    public static final int TAG_STATIC_FIELD = 8;
    public static final int TAG_REFLOCATION = 9;
    public static final int TAG_EXPORT = 10;
    public static final int TAG_DESCRIPTOR = 11;
    public static final int TAG_DEBUG = 12;
    public static final String[] NAMES = new String[]{"", "Header.cap", "Directory.cap", "Applet.cap", "Import.cap", "ConstantPool.cap", "Class.cap", "Method.cap", "StaticField.cap", "RefLocation.cap", "Export.cap", "Descriptor.cap", "Debug.cap"};
    public static final int[] LOAD_ORDER = new int[]{1, 2, 4, 3, 6, 7, 8, 10, 5, 9, 11};

    public CapComponent(CapFile cap, int tag, String fullName) {
        this.cap = cap;
        this.tag = tag;
        this.fullName = fullName;
    }

    public abstract Binary toBin();

    public static int findTag(String name) {
        int i = 1;
        while (i < NAMES.length) {
            if (name.endsWith(NAMES[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static CapComponent parse(CapFile cap, String name, Binary fullBody) {
        Ex.MUST(fullBody.size() > 3, "Wrong CAP component size");
        int tag = fullBody.get(0);
        switch (tag) {
            case 1: {
                return new ComponentHeader(cap, name, fullBody);
            }
            case 2: {
                return new ComponentDirectory(cap, name, fullBody);
            }
            case 3: {
                return new ComponentApplet(cap, name, fullBody);
            }
            case 4: {
                return new ComponentImport(cap, name, fullBody);
            }
            case 5: {
                return new ComponentConstantPool(cap, name, fullBody);
            }
            case 6: {
                return new ComponentClass(cap, name, fullBody);
            }
            case 7: {
                return new ComponentMethod(cap, name, fullBody);
            }
            case 8: {
                return new ComponentStaticField(cap, name, fullBody);
            }
            case 9: {
                return new ComponentRefLocation(cap, name, fullBody);
            }
            case 10: {
                return new ComponentExport(cap, name, fullBody);
            }
            case 11: {
                return new ComponentDescriptor(cap, name, fullBody);
            }
            case 12: {
                return new ComponentDebug(cap, name, fullBody);
            }
        }
        throw new Ex("Wrong CAP component");
    }
}

