/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.CapFile;

public class ComponentApplet
extends CapComponent {
    public int tag;
    public int size;
    public AppletInfo[] applets;

    public ComponentApplet(CapFile cap, String fullName, Binary b) {
        super(cap, 3, fullName);
        int offs = 0;
        this.tag = b.get(offs++);
        this.size = b.getU16(offs);
        offs += 2;
        int count = b.get(offs++);
        this.applets = new AppletInfo[count];
        int i = 0;
        while (i < this.applets.length) {
            AppletInfo app = new AppletInfo();
            int aidLen = b.get(offs++);
            app.aid = b.slice(offs, aidLen);
            app.installMethodOffset = b.getU16(offs += aidLen);
            offs += 2;
            this.applets[i] = app;
            ++i;
        }
        Ex.MUST(this.tag == 3 && this.size == b.size() - 3 && offs == b.size(), "Wrong component Applet");
    }

    @Override
    public Binary toBin() {
        Binary b = Binary.Bin().reserve(this.size + 3);
        b.add(this.tag);
        b.addU16(this.size);
        b.add(this.applets.length);
        AppletInfo[] appletInfoArray = this.applets;
        int n = this.applets.length;
        int n2 = 0;
        while (n2 < n) {
            AppletInfo app = appletInfoArray[n2];
            b.add(app.aid.size());
            b.add(app.aid);
            b.addU16(app.installMethodOffset);
            ++n2;
        }
        return b;
    }

    public static class AppletInfo {
        public Binary aid;
        public int installMethodOffset;
    }
}

