/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import java.util.ArrayList;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.CapFile;
import org.denom.smartcard.cap.ComponentConstantPool;
import org.denom.smartcard.cap.ComponentHeader;

public class ComponentClass
extends CapComponent {
    public int tag;
    public int size;
    public ArrayList<TypeDescriptor> signaturePool;
    public ArrayList<InterfaceInfo> interfaces;
    public ArrayList<ClassInfo> classes;
    public static final byte ACC_INTERFACE = 8;
    public static final byte ACC_SHAREABLE = 4;
    public static final byte ACC_REMOTE = 2;

    public ComponentClass(CapFile cap, String fullName, Binary b) {
        super(cap, 6, fullName);
        int offs = 0;
        this.tag = b.get(offs++);
        this.size = b.getU16(offs);
        offs += 2;
        int minorVersion = ((ComponentHeader)cap.getComp((int)1)).minorVersion;
        this.signaturePool = new ArrayList();
        this.interfaces = new ArrayList();
        this.classes = new ArrayList();
        if (minorVersion == 2) {
            int sigPoolLen = b.getU16(offs);
            int startOffset = offs += 2;
            int len = 0;
            while (len < sigPoolLen) {
                TypeDescriptor td = new TypeDescriptor();
                offs = td.parse(b, offs);
                this.signaturePool.add(td);
                len = offs - startOffset;
            }
        }
        while (offs < b.size()) {
            int flags = b.get(offs);
            if ((flags & 8) != 0) {
                InterfaceInfo intf = new InterfaceInfo();
                offs = intf.parse(b, offs);
                this.interfaces.add(intf);
                continue;
            }
            ClassInfo cl = new ClassInfo();
            offs = cl.parse(b, offs);
            this.classes.add(cl);
        }
        Ex.MUST(this.tag == 6 && this.size == b.size() - 3 && offs == b.size(), "Wrong component Class");
    }

    @Override
    public Binary toBin() {
        Binary b = Binary.Bin().reserve(this.size + 3);
        b.add(this.tag);
        b.addU16(this.size);
        int minorVersion = ((ComponentHeader)this.cap.getComp((int)1)).minorVersion;
        if (minorVersion == 2) {
            Binary sp = Binary.Bin().reserve(100);
            for (TypeDescriptor td : this.signaturePool) {
                td.toBin(sp);
            }
            b.addU16(sp.size());
            b.add(sp);
        }
        for (InterfaceInfo intf : this.interfaces) {
            intf.toBin(b);
        }
        for (ClassInfo cl : this.classes) {
            cl.toBin(b);
        }
        return b;
    }

    public static class ClassInfo {
        public int flags;
        public ComponentConstantPool.ClassRef superClass;
        public int declaredInstanceSize;
        public int firstReferenceToken;
        public int referenceCount;
        public int publicMethodTableBase;
        public int publicMethodTableCount;
        public int packageMethodTableBase;
        public int packageMethodTableCount;
        public int[] publicVMT;
        public int[] packageVMT;
        public ImplementedInterfaceInfo[] interfaces;
        public RemoteInterfaceInfo remoteInterfaces;

        public int parse(Binary b, int offs) {
            int b0 = b.get(offs++);
            this.flags = b0 >> 4;
            int interfaceCount = b0 & 0xF;
            this.superClass = new ComponentConstantPool.ClassRef();
            offs = this.superClass.parse(b, offs);
            this.declaredInstanceSize = b.get(offs++);
            this.firstReferenceToken = b.get(offs++);
            this.referenceCount = b.get(offs++);
            this.publicMethodTableBase = b.get(offs++);
            this.publicMethodTableCount = b.get(offs++);
            this.packageMethodTableBase = b.get(offs++);
            this.packageMethodTableCount = b.get(offs++);
            this.publicVMT = new int[this.publicMethodTableCount];
            int i = 0;
            while (i < this.publicVMT.length) {
                this.publicVMT[i] = b.getU16(offs);
                offs += 2;
                ++i;
            }
            this.packageVMT = new int[this.packageMethodTableCount];
            i = 0;
            while (i < this.packageVMT.length) {
                this.packageVMT[i] = b.getU16(offs);
                offs += 2;
                ++i;
            }
            this.interfaces = new ImplementedInterfaceInfo[interfaceCount];
            i = 0;
            while (i < this.interfaces.length) {
                this.interfaces[i] = new ImplementedInterfaceInfo();
                offs = this.interfaces[i].parse(b, offs);
                ++i;
            }
            if ((this.flags & 2) != 0) {
                this.remoteInterfaces = new RemoteInterfaceInfo();
                offs = this.remoteInterfaces.parse(b, offs);
            }
            return offs;
        }

        public void toBin(Binary b) {
            int n;
            b.add(this.flags << 4 | this.interfaces.length);
            this.superClass.toBin(b);
            b.add(this.declaredInstanceSize);
            b.add(this.firstReferenceToken);
            b.add(this.referenceCount);
            b.add(this.publicMethodTableBase);
            b.add(this.publicMethodTableCount);
            b.add(this.packageMethodTableBase);
            b.add(this.packageMethodTableCount);
            Object[] objectArray = this.publicVMT;
            int n2 = this.publicVMT.length;
            int n3 = 0;
            while (n3 < n2) {
                n = objectArray[n3];
                b.addU16(n);
                ++n3;
            }
            objectArray = this.packageVMT;
            n2 = this.packageVMT.length;
            n3 = 0;
            while (n3 < n2) {
                n = objectArray[n3];
                b.addU16(n);
                ++n3;
            }
            objectArray = this.interfaces;
            n2 = this.interfaces.length;
            n3 = 0;
            while (n3 < n2) {
                int intf = objectArray[n3];
                intf.toBin(b);
                ++n3;
            }
            if (this.remoteInterfaces != null) {
                this.remoteInterfaces.toBin(b);
            }
        }
    }

    public static class ImplementedInterfaceInfo {
        public ComponentConstantPool.ClassRef intf;
        public Binary index;

        public int parse(Binary b, int offs) {
            this.intf = new ComponentConstantPool.ClassRef();
            offs = this.intf.parse(b, offs);
            int count = b.get(offs++);
            this.index = b.slice(offs, count);
            return offs += count;
        }

        public void toBin(Binary b) {
            this.intf.toBin(b);
            b.add(this.index.size());
            b.add(this.index);
        }
    }

    public static class InterfaceInfo {
        public int flags;
        public ComponentConstantPool.ClassRef[] superInterfaces;
        Binary interfaceName;

        public int parse(Binary b, int offs) {
            int b0 = b.get(offs++);
            this.flags = b0 >> 4;
            int interfaceCount = b0 & 0xF;
            this.superInterfaces = new ComponentConstantPool.ClassRef[interfaceCount];
            int i = 0;
            while (i < interfaceCount) {
                this.superInterfaces[i] = new ComponentConstantPool.ClassRef();
                offs = this.superInterfaces[i].parse(b, offs);
                ++i;
            }
            if ((this.flags & 2) != 0) {
                int len = b.get(offs++);
                this.interfaceName = b.slice(offs, len);
                offs += len;
            }
            return offs;
        }

        public void toBin(Binary b) {
            b.add(this.flags << 4 | this.superInterfaces.length);
            ComponentConstantPool.ClassRef[] classRefArray = this.superInterfaces;
            int n = this.superInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentConstantPool.ClassRef cr = classRefArray[n2];
                cr.toBin(b);
                ++n2;
            }
            if (this.interfaceName != null) {
                b.add(this.interfaceName.size());
                b.add(this.interfaceName);
            }
        }
    }

    public static class RemoteInterfaceInfo {
        public RemoteMethodInfo[] remoteMethods;
        public Binary hashModifier;
        public Binary className;
        public ComponentConstantPool.ClassRef[] remoteInterfaces;

        public int parse(Binary b, int offs) {
            int count = b.get(offs++);
            this.remoteMethods = new RemoteMethodInfo[count];
            int i = 0;
            while (i < count) {
                this.remoteMethods[i] = new RemoteMethodInfo();
                offs = this.remoteMethods[i].parse(b, offs);
                ++i;
            }
            int len = b.get(offs++);
            this.hashModifier = b.slice(offs, len);
            offs += len;
            len = b.get(offs++);
            this.className = b.slice(offs, len);
            offs += len;
            count = b.get(offs++);
            this.remoteInterfaces = new ComponentConstantPool.ClassRef[count];
            int i2 = 0;
            while (i2 < count) {
                this.remoteInterfaces[i2] = new ComponentConstantPool.ClassRef();
                offs = this.remoteInterfaces[i2].parse(b, offs);
                ++i2;
            }
            return offs;
        }

        public void toBin(Binary b) {
            b.add(this.remoteMethods.length);
            Object[] objectArray = this.remoteMethods;
            int n = this.remoteMethods.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteMethodInfo m = objectArray[n2];
                m.toBin(b);
                ++n2;
            }
            b.add(this.hashModifier.size());
            b.add(this.hashModifier);
            b.add(this.className.size());
            b.add(this.className);
            b.add(this.remoteInterfaces.length);
            objectArray = this.remoteInterfaces;
            n = this.remoteInterfaces.length;
            n2 = 0;
            while (n2 < n) {
                Object cl = objectArray[n2];
                ((ComponentConstantPool.ClassRef)cl).toBin(b);
                ++n2;
            }
        }
    }

    public static class RemoteMethodInfo {
        public int remoteMethodHash;
        public int signatureOffset;
        public int virtualMethodToken;

        public int parse(Binary b, int offs) {
            this.remoteMethodHash = b.getU16(offs);
            this.signatureOffset = b.getU16(offs += 2);
            offs += 2;
            this.virtualMethodToken = b.get(offs++);
            return offs;
        }

        public void toBin(Binary b) {
            b.addU16(this.remoteMethodHash);
            b.addU16(this.signatureOffset);
            b.add(this.virtualMethodToken);
        }
    }

    public static class TypeDescriptor {
        public int nibbleCount;
        public Binary type;

        public int parse(Binary b, int offs) {
            this.nibbleCount = b.get(offs++);
            int sz = (this.nibbleCount + 1) / 2;
            this.type = b.slice(offs, sz);
            return offs += sz;
        }

        public void toBin(Binary b) {
            b.add(this.nibbleCount);
            b.add(this.type);
        }
    }
}

