/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.CapFile;

public class ComponentExport
extends CapComponent {
    public int tag;
    public int size;
    public ClassExportInfo[] classExports;

    public ComponentExport(CapFile cap, String fullName, Binary b) {
        super(cap, 10, fullName);
        int offs = 0;
        this.tag = b.get(offs++);
        this.size = b.getU16(offs);
        offs += 2;
        int count = b.get(offs++);
        this.classExports = new ClassExportInfo[count];
        int i = 0;
        while (i < this.classExports.length) {
            this.classExports[i] = new ClassExportInfo();
            offs = this.classExports[i].parse(b, offs);
            ++i;
        }
        Ex.MUST(this.tag == 10 && this.size == b.size() - 3 && offs == b.size(), "Wrong component Export");
    }

    @Override
    public Binary toBin() {
        Binary b = Binary.Bin().reserve(this.size + 3);
        b.add(this.tag);
        b.addU16(this.size);
        b.add(this.classExports.length);
        ClassExportInfo[] classExportInfoArray = this.classExports;
        int n = this.classExports.length;
        int n2 = 0;
        while (n2 < n) {
            ClassExportInfo cl = classExportInfoArray[n2];
            cl.toBin(b);
            ++n2;
        }
        return b;
    }

    public static class ClassExportInfo {
        int classOffset;
        int[] staticFieldOffsets;
        int[] staticMethodOffsets;

        public int parse(Binary b, int offs) {
            this.classOffset = b.getU16(offs);
            offs += 2;
            int staticFieldCount = b.get(offs++);
            int staticMethodCount = b.get(offs++);
            this.staticFieldOffsets = new int[staticFieldCount];
            int i = 0;
            while (i < staticFieldCount) {
                this.staticFieldOffsets[i] = b.getU16(offs);
                offs += 2;
                ++i;
            }
            this.staticMethodOffsets = new int[staticMethodCount];
            i = 0;
            while (i < staticMethodCount) {
                this.staticMethodOffsets[i] = b.getU16(offs);
                offs += 2;
                ++i;
            }
            return offs;
        }

        public void toBin(Binary b) {
            int n;
            b.addU16(this.classOffset);
            b.add(this.staticFieldOffsets.length);
            b.add(this.staticMethodOffsets.length);
            int[] nArray = this.staticFieldOffsets;
            int n2 = this.staticFieldOffsets.length;
            int n3 = 0;
            while (n3 < n2) {
                n = nArray[n3];
                b.addU16(n);
                ++n3;
            }
            nArray = this.staticMethodOffsets;
            n2 = this.staticMethodOffsets.length;
            n3 = 0;
            while (n3 < n2) {
                n = nArray[n3];
                b.addU16(n);
                ++n3;
            }
        }
    }
}

