/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.CapFile;
import org.denom.smartcard.cap.ComponentHeader;

public class ComponentImport
extends CapComponent {
    public int tag;
    public int size;
    public ComponentHeader.PackageInfo[] packages;

    public ComponentImport(CapFile cap, String fullName, Binary b) {
        super(cap, 4, fullName);
        int offs = 0;
        this.tag = b.get(offs++);
        this.size = b.getU16(offs);
        offs += 2;
        int count = b.get(offs++);
        this.packages = new ComponentHeader.PackageInfo[count];
        int i = 0;
        while (i < this.packages.length) {
            this.packages[i] = new ComponentHeader.PackageInfo();
            offs = this.packages[i].parse(b, offs);
            ++i;
        }
        Ex.MUST(this.tag == 4 && this.size == b.size() - 3 && offs == b.size(), "Wrong component Import");
    }

    @Override
    public Binary toBin() {
        Binary b = Binary.Bin().reserve(this.size + 3);
        b.add(this.tag);
        b.addU16(this.size);
        b.add(this.packages.length);
        ComponentHeader.PackageInfo[] packageInfoArray = this.packages;
        int n = this.packages.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentHeader.PackageInfo pkg = packageInfoArray[n2];
            pkg.toBin(b);
            ++n2;
        }
        return b;
    }
}

